from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction


class PrintPostMigrationReportAfterTransfer(CommonAction):
	def get_description(self):
		return messages.PRINT_POST_MIGRATION_REPORT_ACTION_DESCRIPTION

	def filter_action(self, global_context):
		"""Check whether we should run this action or not. By default True - action should be executed.

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:rtype: bool
		"""
		return global_context.options.run_post_migration_checks

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.PRINT_POST_MIGRATION_REPORT_ACTION_FAILURE

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		global_context.migrator._print_post_migration_check_report(
			'test_all_report',
			exit_with_exit_code=False
		)