from parallels.core.utils.common.threading_utils import execute_once_synchronized_by_args
from parallels.plesk.source.legacy.pmm_agent import UnixPmmMigrationAgent


class CpanelPmmMigrationAgent(UnixPmmMigrationAgent):
	def __init__(self, global_context, server, migrator_pmm_dir, settings):
		cli_options = '--dump-all --configuration-only --server -v 5'
		super(CpanelPmmMigrationAgent, self).__init__(
			global_context,
			server,
			migrator_pmm_dir,
			settings,
			cli_options
		)

	@execute_once_synchronized_by_args
	def get_mysql_credentials(self):
		with self._source_server.runner() as runner:
			return runner.sh(
				ur'cd {path}; perl getMysqlCredentials.pl', {'path': self.agent_dir},
				# do not log password due to security consideration
				log_output=False
			).strip().split("\n")

	def get_vhosts_dir(self, sysuser):
		with self._source_server.runner() as runner:
			return runner.sh(ur'cd {path}; perl getVhostsDir.pl --sysuser {sysuser}', {
				'path': self.agent_dir,
				'sysuser': sysuser
			}).strip()
