from parallels.plesk import messages
from parallels.core.actions.base.entry_point_action import EntryPointAction
from parallels.core.actions.base.legacy_action import LegacyAction
from parallels.core.actions.hosting_settings.check.check_database_conflicts import CheckDatabaseConflicts
from parallels.core.utils.backup_adapter import SubscriptionBackupRaw, SubscriptionBackup
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.actions.check_target_license_limits import CheckTargetLicenseLimits
from parallels.plesk.actions.create_hosting_plans import CreateHostingPlans
from parallels.plesk.actions.create_reseller_plans import CreateResellerPlans
from parallels.plesk.actions.convert import ConvertAuxUsers
from parallels.plesk.actions.convert import ConvertAuxUserRoles
from parallels.core.actions.restore.plesk.import_clients import ImportClients
from parallels.core.actions.restore.plesk.import_subscriptions import ImportSubscriptions
from parallels.core.actions.restore.auxusers import RestoreAuxUsers
from parallels.core.actions.restore.auxuser_roles import RestoreAuxUserRoles
from parallels.plesk.actions.hosting_settings.check.check_missing_components import CheckMissingComponents
from parallels.plesk.actions.hosting_settings.convert.change_no_hosting_subscription_web_ips import \
	ChangeNoHostingSubscriptionWebIPsPlesk
from parallels.plesk.actions.hosting_settings.convert.remove_missing_components import RemoveMissingComponents
from parallels.plesk.actions.live_migration import LiveMigration
from parallels.plesk.actions.re_sync_web_files_after_live_migration import ReSyncWebFilesAfterLiveMigration
from parallels.plesk.actions.hosting_settings.restore_catch_all_smartermail_assimilate import \
	RestoreCatchAllSmartermailAssimilate
from parallels.plesk.actions.hosting_settings.reset_hosting_for_nohosting_subscription import \
	ResetHostingForSubscriptionWithoutHosting
from parallels.plesk.actions.hosting_settings.verify import VerifyHostingSettings
from parallels.plesk.actions.apache_restart_interval.restore import RestoreApacheRestartIntervalPlesk
from parallels.plesk.actions.apache_restart_interval.set import SetApacheRestartInterval
from parallels.plesk.actions.sync_subscription_plan import SyncSubscriptionPlan


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with plesk-specific actions

		:type workflow parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		# Automatically create resellers and plans when migrating to Plesk.
		# It means that customer can run migration in just one simple step
		# - "transfer-accounts" with no need to remember "import-resellers"
		# and "import-plans".
		workflow.get_path('transfer-accounts').insert_action('import-resellers', LegacyAction(
			description=messages.ACTION_IMPORT_RESELLERS,
			function=lambda ctx: ctx.migrator._import_resellers(ctx.options)
		), after='fetch-target')
		workflow.get_path('transfer-accounts').insert_action(
			'import-plans', CreateHostingPlans(), after='import-resellers'
		)
		# Re-fetch data for further conversions to detect new resellers and
		# their plans
		workflow.get_path('transfer-accounts').insert_action(
			'refetch-source', workflow.get_shared_action('fetch-source'),
			after='import-plans'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'refetch-target', workflow.get_shared_action('fetch-target'),
			after='refetch-source'
		)

		workflow.get_path('transfer-accounts').insert_action(
			'check-plesk-infrastructure',
			workflow.get_shared_action_pointer('check-infrastructure'),
			after='convert'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'create-admin-reseller-plans',
			CreateResellerPlans(),
			before='import-resellers'
		)
		workflow.get_path('import-resellers').insert_action(
			'create-admin-reseller-plans',
			CreateResellerPlans(),
			before='import-resellers'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'restore-apache-restart-interval', RestoreApacheRestartIntervalPlesk(), after='remove-imported-backups'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'set-apache-restart-interval', SetApacheRestartInterval(), after='check-main-node-disk-space-requirements'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'convert-aux-user-roles', ConvertAuxUsers(), after='convert')
		workflow.get_path('transfer-accounts').insert_action(
			'convert-aux-user-roles', ConvertAuxUserRoles(), after='convert')
		workflow.get_path('transfer-accounts/restore').insert_action(
			'import-clients', ImportClients())
		workflow.get_path('transfer-accounts/restore').insert_action(
			'import-subscriptions', ImportSubscriptions())
		workflow.get_path('transfer-accounts').insert_action(
			'restore-auxusers', RestoreAuxUsers(), after='restore')
		workflow.get_path('transfer-accounts').insert_action(
			'restore-auxuser-roles', RestoreAuxUserRoles(), after='restore')
		workflow.get_path('transfer-accounts').insert_action(
			'live-migration', LiveMigration(), after='copy-content')
		workflow.get_path('transfer-accounts').insert_action(
			're-sync-web-files', ReSyncWebFilesAfterLiveMigration(), after='live-migration')
		workflow.get_path('transfer-accounts/restore-hosting').insert_action(
			'restore-catch-all-smartermail-assimilate', RestoreCatchAllSmartermailAssimilate(),
			after='restore-hosting-settings'
		)
		workflow.get_path('transfer-accounts/restore-hosting').insert_action(
			'reset-hosting-for-subscription-without-hosting',
			ResetHostingForSubscriptionWithoutHosting(), after='import-backups'
		)
		workflow.get_path('transfer-accounts').register_shutdown(
			'set-apache-restart-interval',
			'restore-apache-restart-interval'
		)

		workflow.get_shared_action('verify-hosting').insert_action(
			'verify-hosting-settings', VerifyHostingSettings()
		)

		# For Plesk, we can perform the database conflicts check on pre-migration
		# as we know target database server location
		workflow.get_path('check/check-data').insert_action(
			'check-database-conflicts',
			CheckDatabaseConflicts(SubscriptionBackupRaw())
		)

		workflow.get_path('check/check-data').insert_action(
			'check-missing-conflicts',
			CheckMissingComponents()
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'remove-missing-components',
			RemoveMissingComponents(),
			before='save-backup'
		)

		workflow.get_path('check/check-data').insert_action(
			'check-target-license-limits', CheckTargetLicenseLimits()
		)
		workflow.get_path('transfer-accounts').insert_action(
			'check-target-license-limits', CheckTargetLicenseLimits(), before='convert'
		)
		workflow.get_path('transfer-accounts').insert_action(
			'sync-subscription-plan', SyncSubscriptionPlan(), after='copy-content'
		)
		workflow.get_shared_action('convert-hosting').insert_action(
			'change-no-hosting-subscription-web-ips',
			ChangeNoHostingSubscriptionWebIPsPlesk(SubscriptionBackup()),
			after='change-hosting-subscription-web-ips'
		)

		self._configure_entry_point_import_plans(workflow)

	@staticmethod
	def _configure_entry_point_import_plans(workflow):
		workflow.replace_entry_point('import-plans', EntryPointAction())
		workflow.get_path('import-plans').insert_actions(
			workflow.get_shared_action('initial-pre-checks').get_all_actions()
		)
		workflow.get_path('import-plans').insert_action(
			'fetch-source',
			workflow.get_shared_action('fetch-source')
		)
		workflow.get_path('import-plans').insert_action(
			'import-plans', CreateHostingPlans()
		)
		workflow.get_path('import-plans').insert_action(
			'cleanup',
			workflow.get_shared_action('cleanup')
		)
		workflow.get_path('import-plans').register_overall_shutdown('cleanup')
