from parallels.core.utils.backup_adapter import SubscriptionBackup
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.ppa.source.helm3.actions.content.mail.copy_content import CopyMailContentFromHelm3ToPPA
from parallels.ppa.source.helm3.actions.hosting_settings.convert.ftp_user_login import FTPUserLogin
from parallels.plesk.source.helm3.workflow import WorkflowExtension as SourceHelm3WorkflowExtension
from parallels.ppa.source.helm3.actions.hosting_settings.convert.dns import DNS


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		# Base workflow is Expand to Plesk workflow
		SourceHelm3WorkflowExtension().extend_workflow(workflow)

		workflow.get_shared_action('convert-hosting').insert_action(
			'change-ftp-logins', FTPUserLogin(SubscriptionBackup()),
			before='save-backup'
		)
		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', DNS()
		)
		workflow.replace_shared_action('copy-mail-content', CopyMailContentFromHelm3ToPPA())
