import logging

from parallels.core.actions.base.common_action import CommonAction
from parallels.shcm_web_sn import messages

logger = logging.getLogger(__name__)


class RereadIPsAction(CommonAction):
	"""
	Action to make sure that in the target SHM context DB webspace target IPs are present.
	PMM conflict resolver will report conflict otherwise.
	"""
	def get_description(self):
		return messages.REREAD_IPS_ON_TARGET_PPA_WEB_SN

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_TO_REREAD_IPS_ON_TARGET_PPA_WEB_SN

	def run(self, global_context):
		"""
		:type global_context: parallels.shcm_web_sn.source.shcm_web_sn.global_context.SHCMMoveWebspacesGlobalMigrationContext
		"""
		cmd = '/usr/local/psa/bin/ipmanage'
		for ip, ip_type in (global_context.webspace_ipv4, global_context.webspace_ipv4_type), \
						   (global_context.webspace_ipv6, global_context.webspace_ipv6_type):
			if not ip:
				continue

			cmd_args = ['--reread-ip', ip]
			if ip_type == 'shared':
				cmd_args.append('-type')
				cmd_args.append('shared')

			with global_context.conn.target.plesk_server.runner() as runner:
				runner.run(cmd, args=cmd_args, env=global_context.webspace_dst_ctx.get_as_env())
