package ConfixxGuidGenerator;

use strict;

use UUID::Tiny ':std';
use ConfixxConfig;

use constant CONFIXX_ADMIN_NAMESPACE_GUID    => string_to_uuid('5e31d062-ff40-11e2-bd5d-003048db220a');
use constant CONFIXX_RESELLER_NAMESPACE_GUID => string_to_uuid('5e553a16-ff40-11e2-9400-003048db220a');
use constant CONFIXX_CLIENT_NAMESPACE_GUID   => string_to_uuid('5e74ef8c-ff40-11e2-97f6-003048db220a');
use constant CONFIXX_DOMAIN_NAMESPACE_GUID   => string_to_uuid('5e9240dc-ff40-11e2-9c97-003048db220a');
use constant CONFIXX_USER_NAMESPACE_GUID   => string_to_uuid('5e9240de-ff40-11e2-9c97-003048db220a');

my $uuidType = UUID_SHA1_AVAIL() ? UUID_V5 : UUID_V3;

sub getAdminGuid() {
  return getUuidV35(CONFIXX_ADMIN_NAMESPACE_GUID, ConfixxConfig::getValue('hostname'));
}

sub getResellerGuid($) {
  my ($resellerId) = @_;
  return getUuidV35(CONFIXX_RESELLER_NAMESPACE_GUID, ConfixxConfig::getValue('hostname') . ':' . $resellerId);
}

sub getClientGuid($) {
  my ($clientId) = @_;
  return getUuidV35(CONFIXX_CLIENT_NAMESPACE_GUID, ConfixxConfig::getValue('hostname') . ':' . $clientId);
}

sub getDomainGuid($) {
  my ($domainId) = @_;
  return getUuidV35(CONFIXX_DOMAIN_NAMESPACE_GUID, ConfixxConfig::getValue('hostname') . ':' . $domainId);
}

sub getUserGuid($) {
  my ($userId) = @_;
  return getUuidV35(CONFIXX_USER_NAMESPACE_GUID, ConfixxConfig::getValue('hostname') . ':' . $userId);
}

sub getUuidV35($$) {
  my ($namespace, $name) = @_;
  return uuid_to_string(create_uuid($uuidType, $namespace, $name));
}

1;
