from collections import namedtuple

from .. import core

SubdomainInfo = namedtuple('SubdomainInfo', ('id', 'name', 'parent'))


class SubdomainOperator(object):
	FilterAll = core.FilterAll
	FilterByName = core.declare_filter('FilterByName', 'name')
	FilterByParentName = core.declare_filter('FilterByParentName', 'parent-name')

	class Get(core.operation_with_filter('Get')):
		operator_name = 'subdomain'
		operation_name = 'get'
		min_api_version = '1.5.2.0'
		max_api_version = None

		@classmethod
		def parse(cls, elem):
			return core.filter_owner_not_found_error(core.parse_result_set(elem, cls._parse_data, 'id'))

		@classmethod
		def _parse_data(cls, elem):
			id = elem.findtext('id')
			name = elem.findtext('data/name')
			parent = elem.findtext('data/parent')

			return id, SubdomainInfo(id = id, name = name, parent = parent)