from parallels.core.utils import plesk_utils
from parallels.plesk.actions.apache_restart_interval.restore import RestoreApacheRestartIntervalBase


class RestoreApacheRestartIntervalPPA(RestoreApacheRestartIntervalBase):
	@staticmethod
	def _restart_apache(global_context, target_server):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type target_server: parallels.core.connections.plesk_server.PleskServer
		"""
		for apache_node_id in [1] + global_context.import_api.list_service_node_ids('ppa_apache'):
			with global_context.conn.target.ppa_unix_node_runner(apache_node_id) as runner:
				plesk_utils.restart_plesk_apache(runner)