from parallels.ppa.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertPPADNS
from parallels.plesk.utils.xml_rpc.plesk.operator.dns import DnsRecord

class DNS(ActionHostingSettingsConvertPPADNS):
	def _get_source_dns_template(self, global_context, subscription):
		"""Make server DNS template like DNS server template in Plesk

		It is necessary for PPA DNS conversion algorithm to work correctly.
		Backup argument is not used for Helm 3 migrator. It's used in Plesks
		migrators.
		"""
		server_dns_template = [
			DnsRecord(id=None, rec_type='NS', src='<domain>', dst='<ip>', opt=''),
			DnsRecord(id=None, rec_type='A', src='<domain>', dst='<ip>', opt=''),
			DnsRecord(id=None, rec_type='A', src='*.<domain>.', dst='<ip>', opt=''),
			DnsRecord(id=None, rec_type='A', src='www.<domain>.', dst='<ip>', opt=''),
			DnsRecord(id=None, rec_type='A', src='ftp.<domain>.', dst='<ip>', opt=''),
			DnsRecord(id=None, rec_type='A', src='mail.<domain>.', dst='<ip.mail>', opt=''),
			DnsRecord(id=None, rec_type='TXT', src='<domain>', dst='v=spf1 a mx -all', opt='')
		]
		return server_dns_template
