from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.ppa.source.hsphere import messages

from parallels.core.actions.base.legacy_action \
	import LegacyAction
from parallels.core.actions.base.entry_point_action \
	import EntryPointAction

from parallels.ppa.source.hsphere.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS
from parallels.ppa.source.hsphere.actions.content.web.copy_windows_web_content \
	import CopyWindowsWebContent
from parallels.ppa.source.hsphere.actions.content.web.copy_unix_web_content \
	import CopyUnixWebContent
from parallels.core.actions.content.web.fix_unix_vhost_permissions \
	import FixUnixVhostPermissions
from parallels.plesk.source.plesk.actions.content.web.reset_permissions \
	import ResetPermissions
from parallels.ppa.source.hsphere.actions.hosting_settings.convert.remove_subdomain_mail \
	import RemoveSubdomainMail
from parallels.ppa.source.hsphere.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.ppa.source.hsphere.actions.hosting_settings.transfer_error_documents \
	import TransferErrorDocuments
from parallels.ppa.source.hsphere.actions.hosting_settings.transfer_mime_types \
	import TransferMIMETypes
from parallels.ppa.source.hsphere.actions.dns_forwarding.forwarding.undo_not_supported \
	import UndoNotSupported
from parallels.ppa.source.hsphere.actions.hosting_settings.check.mailsystem_on_subdomains \
	import MailsystemOnSubdomains

from parallels.core.utils.backup_adapter import SubscriptionBackup
from parallels.core.utils.backup_adapter import SubscriptionBackupRaw


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		workflow.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description=messages.FETCH_DATA_FROM_SOURCE_HSPHERE,
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		workflow.get_path('transfer-accounts/restore-hosting').insert_action(
			'transfer-ip-access-restrictions', LegacyAction(
				description=messages.TRANSFER_IP_ACCESS_RESTRICTIONS,
				function=lambda ctx: ctx.migrator._transfer_ip_access_restrictions()
			)
		)

		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)
		workflow.get_path('transfer-accounts').insert_action('transfer-resource-limits', LegacyAction(
			description='Transfer resource limits',
			function=lambda ctx: ctx.migrator._transfer_resource_limits(ctx.options)
		), after='restore')

		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-files-unix', CopyUnixWebContent()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-permissions', FixUnixVhostPermissions()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'copy-files-windows', CopyWindowsWebContent()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'reset-permissions', ResetPermissions()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-error-documents', TransferErrorDocuments()
		)

		workflow.get_shared_action(
			'convert-hosting'
		).insert_action(
			'remove-subdomains-mail', RemoveSubdomainMail(SubscriptionBackup())
		)

		workflow.get_path('check/check-data').insert_action(
			'check-mail-on-subdomains', MailsystemOnSubdomains(SubscriptionBackupRaw())
		)

		workflow.replace_entry_point('set-dns-forwarding', EntryPointAction())
		workflow.replace_entry_point('undo-dns-forwarding', EntryPointAction())

		workflow.get_path('set-dns-forwarding').insert_action(
			'check-connections', LegacyAction(
				description=messages.ACTION_CHECK_CONNECTIONS,
				function=lambda ctx: ctx.migrator._check_connections(ctx.options)
			)
		)
		workflow.get_path('set-dns-forwarding').insert_action(
			'read-migration-list', LegacyAction(
				description=messages.ACTION_READ_MIGRATION_LIST,
				function=lambda ctx: ctx.migrator._read_migration_list_lazy(ctx.options)
			)
		)
		workflow.get_path('set-dns-forwarding').insert_action(
			'forward-dns', LegacyAction(
				description=messages.ACTION_FORWARD_DNS,
				function=lambda ctx: ctx.migrator._forward_dns(ctx.dns_forwarding_report)
			)
		)
		workflow.get_path('set-dns-forwarding').insert_action(
			'cleanup',
			workflow.get_shared_action('cleanup')
		)
		workflow.get_path('set-dns-forwarding').insert_action(
			'print-report', LegacyAction(
				description=messages.ACTION_PRINT_DNS_FORWARDING_REPORT,
				function=lambda ctx: ctx.migrator._print_dns_forwarding_report(ctx.dns_forwarding_report)
			)
		)
		workflow.get_path('set-dns-forwarding').register_overall_shutdown('cleanup')

		workflow.get_path('undo-dns-forwarding').insert_action(
			'not-supported', UndoNotSupported()
		)
