from collections import namedtuple

from .. import core
from parallels.utils.xml import elem, text_elem

class PleskDnsOperator:
	class Refresh(namedtuple('Refresh', ('filter'))):
		class FilterByServerId(namedtuple('ServerId', ('server_id'))):
			def inner_xml(self):
				return [text_elem('server_id', self.server_id)]

		operator_name = 'exp_plesk_dns'
		operation_name = 'refresh'

		def inner_xml(self):
			return [
				elem('filter', self.filter.inner_xml()),
			]
			
		@classmethod
		def parse(cls, elem):
			return [core.Result.parse(r, cls._parse_data) for r in elem.findall('result')]
		
		@classmethod
		def _parse_data(cls, elem):
			pass

