from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import DNSExternalIssueType

MESSAGES = {}

MESSAGES[DNSExternalIssueType.DIFFERENT_RECORDS] = format_message("""
Make sure that domain name is registered and delegated correctly to target Plesk server or source panel DNS servers. Also, after completion of the TTL period, try running the DNS check again.
""")

MESSAGES[DNSExternalIssueType.DNS_SERVER_TIMEOUT] = format_message("""
Make sure that:
1. You specified an external DNS server which is serving the DNS queries for any domain.
2. The requests to the server are not blocked by a firewall.
""")

MESSAGES[DNSExternalIssueType.INTERNAL_ERROR] = format_message("""
Manually check whether this zone is resolved properly by external DNS servers.
""")
