import logging

from parallels.common import restore_hosting
from parallels.common.actions.base.subscription_action import SubscriptionAction

logger = logging.getLogger(__name__)


class RestoreApplications(SubscriptionAction):
	def get_description(self):
		return "Restore APS applications"

	def get_failure_message(self, global_context, subscription):
		return "Failed to restore APS applications settings for subscription '%s'" % (
			subscription.name
		)

	def filter_subscription(self, global_context, subscription):
		return subscription.converted_backup.has_aps

	def run(self, global_context, subscription):
		"""Restore APS applications after copy web content so all configs updated according to new configuration. 
		For example, if database server's IP has been changed, wp-config.php file of Wordpress APS application should 
		be updated accordingly. We should do this after copy-content step, otherwise configuration files are overwritten by copy-content step.
		"""
		logger.info(u"Restore APS applications configuration")

		domain_path = global_context.session_files.get_path_to_converted_plesk_domain_backup(
			subscription.model.source, subscription.name
		)

		backup = subscription.full_converted_backup

		restore_hosting.restore_aps_application_settings(
			global_context.conn.target, backup, domain_path,
			[subscription.name], safe=global_context.safe,
			target_backup_path=global_context.conn.target.main_node_session_file_path('plesk.backup')
		)
