import logging

from parallels.hosting_analyser.hosting_analyser import HostingAnalyser
from parallels.common.actions.base.common_action import CommonAction
from parallels.common.utils.config_utils import ConfigSection

logger = logging.getLogger(__name__)

class AnalyseHosting(CommonAction):
	def get_description(self):
		return "Analysing hosting OS resource usage and webspaces content"

	def get_failure_message(self, global_context):
		return "Failed to analyse migration nodes"

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed, migration tool won't run the next operations.

		:rtype: bool
		"""
		return False

	def filter_action(self, global_context):
		"""Check whether we should run this action or not. By default True - action should be executed.

		Arguments:
		- global_context - registry with different objects that reused among different actions

		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:rtype: bool
		"""

		global_section = ConfigSection(global_context.config, 'GLOBAL')
		return global_section.get('use-hosting-analyser', 'true').lower() == 'true'

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		analyser = HostingAnalyser(global_context.migrator_server)
		if analyser.is_nodes_type_supported(global_context.conn):
			analyser.analyse(global_context.conn, global_context.ssh_key_pool)