from parallels.common.actions.hosting_settings.transfer_error_documents import TransferErrorDocumentsBase
from parallels.common.utils import plesk_utils
from parallels.plesks_migrator.plesk_utils import get_vdirs_list
from parallels.plesks_migrator.plesk_utils import PathConverter
from parallels.common.utils.error_docs_utils import ErrorDocumentsXMLConverter


class TransferErrorDocuments(TransferErrorDocumentsBase):
	def _get_site_error_documents(self, global_context, subscription, site):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		raw_error_documents = plesk_utils.get_error_documents(
			subscription.web_source_server, site.name
		)
		converter = self._create_converter()
		converted_error_documents = converter.convert(subscription, site, raw_error_documents)

		return converted_error_documents

	def _get_site_vdir_error_documents(self, global_context, subscription, site):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		vdirs_list = get_vdirs_list(global_context, subscription, site)
		error_docs = {}
		converter = self._create_converter()
		for vdir in vdirs_list:
			raw_error_docs = plesk_utils.get_error_documents(
				subscription.web_source_server, site.name, vdir
			)
			converted_error_docs = converter.convert(subscription, site, raw_error_docs)
			error_docs[vdir] = converted_error_docs

		return error_docs

	@staticmethod
	def _create_converter():
		converter = ErrorDocumentsXMLConverter()
		path_converter = PathConverter()
		converter.set_path_convert_function(path_converter.convert)
		return converter
