import logging

from parallels.common.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.common.actions.utils.logging_properties \
	import LoggingProperties

logger = logging.getLogger(__name__)


class RemoveSubscriptionExternalId(SubscriptionBackupAction):
	"""Remove external ID for all subscriptions, so that they won't override
	ones assigned by PPA during hosting restoration process."""

	def get_description(self):
		return "Remove external IDs from backup"

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return "Failed to remove external IDs for subscription '%s'" % subscription.name

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		logger.debug(u"Delete subscriptions' external ID")
		subscription_backup.delete_external_id()
