from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.utils.logging_properties import LoggingProperties
from parallels.common.utils.windows_agent_pool import WindowsAgentPool


class ShutdownWindowsAgents(CommonAction):
	def get_description(self):
		return "Shutdown remote Windows agents"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Failed to shutdown remote Windows agents"

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed, migration tool won't run the next operations.

		:rtype: bool
		"""
		return False

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		WindowsAgentPool.get_instance(global_context.migrator_server).close_all()

	def get_logging_properties(self):
		"""Get how action should be logged to migration tools end-user"""
		return LoggingProperties(info_log=False)