class GlobalMigrationContext(object):
	"""
	:type target_panel_obj: parallels.common.target_panel_base.TargetPanelBase
	"""
	def __init__(self):
		self.conn = None  # connections to source and target servers
		self.session_files = None  # utility class to construct paths to session files
		self.migrator_server = None  # instance of MigratorServer
		self.import_api = None
		self.safe = None
		self.webmail_ipv4 = None
		self.target_panel = None
		self.target_panel_obj = None
		self.load_raw_plesk_backup = None
		self.load_converted_plesk_backup = None
		self.load_shallow_plesk_backup = None
		self.source_plesks = None
		self.migration_list_data = None
		self.ip_mapping = None
		self.iter_all_subscriptions = None
		self.options = None
		self.password_holder = None
		self.config = None
		self.target_existing_objects = None
		self.source_has_dns_forwarding = True
		self.ssh_key_pool = None
		self.rsync_pool = None
		self.get_rsync = None

		self.dns_forwarding_report = None
		self.pre_check_report = None
		self.post_migration_check_report = None
		self.test_services_report = None
		self.apache_restart_interval = None

		# XXX Migrator object, for legacy actions - do not use for new code
		# avoid usage for old code
		self.migrator = None

	@property
	def target_model(self):
		return self.migrator._load_ppa_model()

	@property
	def source_server_infos(self):
		"""Information about source servers we have

		:rtype list[parallels.common.global_context.SourceServerInfo]
		"""
		return [
			SourceServerInfo(self, id, settings)
			for id, settings in self.source_plesks.iteritems()
		]


class SourceServerInfo(object):
	"""Class representing all information we have about source server"""
	def __init__(self, global_context, id, settings):
		self._id = id
		self._settings = settings
		self._global_context = global_context

	def load_raw_backup(self):
		"""Load raw backup corresponding to the server"""
		backup = self._global_context.load_raw_plesk_backup(self._settings)
		return backup

	@property
	def id(self):
		"""ID of the server according to config.ini"""
		return self._id

	@property
	def settings(self):
		"""Settings of the server from config.ini"""
		return self._settings
