from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import MSSQLDatabaseIssueType

MESSAGES = {}

MESSAGES[MSSQLDatabaseIssueType.FAILED_TO_LOGIN_TO_TARGET_SERVER_AS_ADMIN] = format_message("""
Failed to log in to the target Microsoft SQL Server '{host}' as the admin user.
Checking of the database '{database}' on the target host will be skipped.
""")

MESSAGES[MSSQLDatabaseIssueType.FAILED_TO_LOGIN_TO_TARGET_DATABASE_AS_ADMIN] = format_message("""
Failed to log in as administrator to the database '{database}' at the target Microsoft SQL Server '{host}'.

""")

MESSAGES[MSSQLDatabaseIssueType.FAILED_TO_FETCH_TABLES_FROM_SOURCE] = format_message("""
Failed to retrieve information about database tables on the source Microsoft SQL Server '{host}'.
Checking of tables of the database '{database}' on the target host will be skipped.
""")

MESSAGES[MSSQLDatabaseIssueType.DIFFERENT_TABLES_SET] = format_message("""
Microsoft SQL Server database '{database}' on the source server and on the target server has a differing set of tables. The databases that are present on the source server, but are missing at the target server: {tables_list}
""")

MESSAGES[MSSQLDatabaseIssueType.FAILED_TO_LOGIN_AS_USER] = format_message("""
Failed to log in as the database user '{user}' to the Microsoft SQL Server database '{database}'
""")

MESSAGES[MSSQLDatabaseIssueType.INTERNAL_ERROR] = format_message("""
An internal error occurred: {reason}
Unable to check whether the Microsoft SQL Server database '{database}' was migrated correctly.
""")

MESSAGES[MSSQLDatabaseIssueType.DATABASE_DOES_NOT_EXIST_IN_PANEL] = format_message("""
MSSQL database '{database}' does not exist on the target panel.
All the other checks for that database will be skipped.
""")

MESSAGES[MSSQLDatabaseIssueType.DATABASE_USER_DOES_NOT_EXIST_IN_PANEL] = format_message("""
Database user '{user}' does not exist for MSSQL database '{database}' on target panel
""")

MESSAGES['mssql_database_listing_script_failed'] = format_message("""
The script for listing Microsoft SQL Server database tables failed with a non-zero exit code. See debug.log for details.
""")
