from parallels.common.connections.target_servers import TargetServers
from parallels.common.hosting_check.entity_source.service import TargetServiceInfo
from parallels.target_panel_plesk.converter.converter import PleskConverter
from parallels.target_panel_plesk.import_api.import_api_unix import PleskUnixImportAPI
from parallels.target_panel_plesk.import_api.import_api_windows import PleskWindowsImportAPI
from parallels.target_panel_ppa.panel import PPATargetPanel
from parallels.target_panel_ppa_web_sn.connections.target_connections import PPAWebSNTargetConnections
from parallels.target_panel_ppa_web_sn.connections.target_server import PPAMoveWebspacesTargetServer
from parallels.utils import cached


class PPAMoveWebspacesTargetPanel(PPATargetPanel):
	@property
	def name(self):
		return 'PPA Web Service Node'

	def has_dns_forwarding(self):
		"""Whether panel should support DNS forwarding migration feature"""
		return False

	@cached
	def get_subscription_nodes(self, global_context, subscription_target_services, subscription_name):
		conn = global_context.conn.target

		return TargetServers(
			web=self._get_target_server(conn),
			mail=None,
			database={},
			dns=[]
		)

	def get_service_nodes(self, conn):
		return [
			TargetServiceInfo(
				service_type='web',
				node=self._get_target_server(conn)
			)
		]

	def get_subscription_plesk_node(self, global_context, subscription_name):
		conn = global_context.conn.target
		return self._get_target_server(conn)

	def get_connections(self, config):
		"""Get target panel connections"""
		return PPAWebSNTargetConnections(config)

	def get_import_api(self, global_context):
		if global_context.conn.target.is_windows:
			return PleskWindowsImportAPI(global_context.conn.target)
		else:
			return PleskUnixImportAPI(global_context.conn.target)

	def get_converter_class(self):
		return PleskConverter

	def get_hosting_check_messages_panel_id(self):
		return 'plesk'

	@cached
	def _get_target_server(self, conn):
		return PPAMoveWebspacesTargetServer(conn)
