from parallels.common import messages
from parallels.common.actions.base.common_action import CommonAction
from parallels.common import MigrationError


class ImportPlansNotSupported(CommonAction):
	def get_description(self):
		return messages.CHECK_IF_TARGET_PANEL_SUPPORTS_PLANS

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_CHECK_IF_TARGET_PANEL_SUPPORTS

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		raise MigrationError(
			messages.SERVICE_PLANS_SERVICE_TEMPLATES_IMPORT_IS)
