from parallels.common.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.common.actions.base.legacy_action \
	import LegacyAction

from parallels.confixx_migrator.actions.content.web.copy_unix_content \
	import ConfixxCopyUnixWebContent
from parallels.confixx_migrator.actions.content.web.fix_permissions \
	import FixPermissions

class FromConfixxWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromConfixxWorkflow, self).__init__()

		self.get_shared_action('copy-web-files').insert_action(
			'copy-files', ConfixxCopyUnixWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixPermissions()
		)
		self.get_path('check/check-data').insert_action(
			'check-additional', LegacyAction(
				description='Check additional',
				function=lambda ctx: ctx.migrator._check_additional(
					ctx.pre_check_report, ctx.target_existing_objects
				)
			)
		)

		self.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description='Fetch data from source Confixx',
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
