from parallels.common.connections.source_server import SingleServerPanelSourceServer
from parallels.common.utils.database_server_type import DatabaseServerType
from parallels.common import MigrationError

class CpanelSourceServer(SingleServerPanelSourceServer):
	def __init__(self, node_id, node_settings):
		super(SingleServerPanelSourceServer, self).__init__(
				node_id, node_settings
		)

	def get_unix_vhost_dirs(self, runner, domain_name):
		"""Return list of directories with domain hosting content."""
		return []

	def get_unix_domain_mail_dirs(self, runner, domain_name):
		"""Return list of directories with system domain mail content."""
		return []

	def get_database_server_password(self, database_server):
		if database_server.type() == DatabaseServerType.POSTGRESQL:
			return self.node_settings.postgres_password
		elif database_server.type() == DatabaseServerType.MYSQL:
			return ''
		else:
			raise MigrationError(
				u'Cannot retrieve password for an unsupported database type "%s"'
				% database_server.type())
