import logging

from .model import Model
from parallels.expand_migrator.expand_data.sources.expand_api import ExpandAPIData
from parallels.expand_migrator.expand_data.sources.expand_database import ExpandDatabaseData


logger = logging.getLogger(__name__)


class ExpandDataSource(object):
	"""Retrieve data from Expand"""

	def __init__(self, expand_main_server):
		self._api_data = ExpandAPIData(expand_main_server.expand_api)
		self._db_data = ExpandDatabaseData(expand_main_server)

	def get_model(self, source_plesks, source_centralized_mail_servers):
		"""
		:rtype: parallels.expand_migrator.expand_data.model.Model
		"""
		logger.debug(u"Get Expand data model")

		expand_plesk_servers = self._db_data.get_servers(source_plesks)
		expand_resellers = self._db_data.get_expand_resellers()
		plesk_domains = self._api_data.get_plesk_domains(expand_plesk_servers)

		return Model(
			servers=expand_plesk_servers,
			centralized_mail_servers=self._api_data.get_centralized_mail_servers(source_centralized_mail_servers),
			expand_clients=self._api_data.get_expand_clients(),
			plesk_clients=list(self._api_data.iter_plesk_clients(expand_plesk_servers)),
			expand_resellers=expand_resellers,
			assigned_plesk_clients=self._db_data.get_assigned_clients(),
			assigned_plesk_domains=self._db_data.get_assigned_domains(),
			plesk_domains=plesk_domains,
			plesk_domain_aliases=self._api_data.get_plesk_domain_aliases(plesk_domains),
			expand_plans=self._db_data.get_expand_plans(expand_resellers),
			dns_server_mapping=self._db_data.get_dns_server_mapping(source_plesks),
			dns_server_ips=self._db_data.get_dns_server_ips(),
			plesk_server_ips=self._api_data.get_plesk_server_ips(),
			mail_server_ips=self._api_data.get_mail_server_ips(),
			db_server_ips=self._api_data.get_db_server_ips(),
		)