
// Show popup dialog with confirmation to cancel all running migrations.
function showCancelAllPopup() {

    var CancelMessageBox = Class.create(Jsw.MessageBox, {
        _defaultOnButtonClick: function() {}
    });

    var messageBox = new CancelMessageBox({
        'type': Jsw.messageBox.TYPE_YESNO,
        'subtype': 'delete',
        'text': migratorLocale.lmsg('popupCancelAllDescription'),
        'onYesClick': function () {
            this._componentElement.select('button').each(function(button) {
                button.disabled = true;
                button.up().addClassName('disabled');
            });
            this._componentElement.select('button').first().update(
                '<span class="wait">' + migratorLocale.lmsg('popupCancelAllInProgress') + '</span>'
            );
            new Ajax.Request(URL_CANCEL, {
                onSuccess: function() {
                    messageBox.hide();
                }
            });
        },
        'onNoClick': function () {
            this.hide();
        },
        'buttonTitles': {
            'yes': migratorLocale.lmsg('popupCancelAllButtonYes'),
            'no': migratorLocale.lmsg('popupCancelAllButtonNo')
        }
    });
    messageBox.show();
}
