from parallels.core import messages
from parallels.core.application_adjuster.application_configs.base import ApplicationConfig
from parallels.core.application_adjuster.application_configs.utils import path_endswith, replace_line
from parallels.core.utils.common import safe_format


class PrestashopApplicationConfig(ApplicationConfig):
    """Class for detection and fixing Prestashop configuration file"""

    def get_config_file_description(self, filename):
        """Human-readable description of configuration file

        :rtype: str | unicode
        """
        return safe_format(
            messages.APPLICATION_FILE_CONFIG_DESCRIPTION,
            filename=filename, application_name='PrestaShop'
        )

    def filename_match(self, path):
        """Check if given path looks like configuration file of Prestashop

        :type path: str | unicode
        :rtype: boolean
        """
        return path_endswith(path, 'settings.inc.php')

    def contents_match(self, contents):
        """Check if given file contents looks like configuration file of Prestashop

        :type contents: str | unicode
        :rtype: boolean
        """
        return '_PS_' in contents

    def fix_database_hostname(self, contents, db_host_mapping):
        """Fix database hostname in configuration file of Prestashop

        :type contents: str | unicode
        :type db_host_mapping: dict[str | unicode, str | unicode]
        :rtype: parallels.core.utils.line_processor.ReplaceResults
        """
        # default config has line like:
        # define('_DB_SERVER_', '192.168.1.2');
        return replace_line(contents, '_DB_SERVER_', "'_DB_SERVER_', '", "'", db_host_mapping)