
class MigrationListReaderBase(object):
    """Base class for reading migration list from file. Subclasses implement different formats (JSON, plain text)"""

    def __init__(self, source_data):
        """Class constructor

        Source data is an object which provides information about subscriptions, customer, resellers, plans, etc
        and their relations.

        :type source_data: parallels.core.migration_list.source_data.MigrationListSourceData
        """
        self._source_data = source_data

    def read(self, fileobj, subscriptions_only=False):
        """Read migration list from file

        Returns tuple, where:
        1) The first element is object which describes migration list data:
        parallels.core.migration_list.entities.list_data.MigrationListData
        2) The second element is list of error messages occurred when reading migration list.

        :param fileobj: file-like object to read migration list from
        :param bool subscriptions_only: whether to include subscriptions only, or also read plans, resellers, etc
        :rtype: tuple(parallels.core.migration_list.entities.list_data.MigrationListData, list[str | unicode))
        """
        raise NotImplementedError()

    def read_resellers(self, fileobj):
        """Read resellers from migration list file

        Returns tuple, where:
        1) The first element is a dictionary, describing resellers:
        {reseller login: reseller plan}.
        If plan is not set and reseller subscription is custom, then reseller plan is None.
        2) The second element is list of error messages occurred when reading migration list.

        :param fileobj: file-like object to read migration list from
        :rtype: tuple(dict[basestring, basestring], list[str | unicode])
        """
        raise NotImplementedError()

    def read_plans(self, fileobj):
        """Read plans from migration list file

        Returns tuple, where:
        1) The first element is object which describes migration list plans:
        parallels.core.migration_list.entities.plans.MigrationListPlans
        2) The second element is list of error messages occurred when reading migration list.

        :param fileobj: file-like object to read migration list from
        :rtype: tuple(parallels.core.migration_list.entities.plans.MigrationListPlans, list[str | unicode])
        """
        raise NotImplementedError()
