from parallels.core.reports.report_writer import ReportWriter


class MultiReportWriter(ReportWriter):
    """Report that redirects all function calls to other reports. If an issue is added, it is added to all the reports.

    :type reports: list[parallels.core.reports.model.report.Report]
    """
    def __init__(self, *reports):
        self._reports = list(reports)

    def add_issue(
        self, issue_id, severity, problem_text, solution_text=None,
        affected_objects=None, solution_type=None,
        solution_url=None, solution_url_text=None, solution_component_name=None,
        solution_download_rpc_agent=False
    ):
        """Add issue to report, by issue parameters

        :rtype: None
        """
        for report in self._reports:
            report.add_issue(
                issue_id, severity, problem_text, solution_text,
                affected_objects, solution_type,
                solution_url, solution_url_text, solution_component_name,
                solution_download_rpc_agent
            )

    def add_issue_obj(self, issue):
        """Add issue to report

        :type issue: parallels.core.reports.model.issue.Issue
        """
        for report in self._reports:
            report.add_issue_obj(issue)

    def subtarget(self, type, name):
        """Get child report by its type and name

        :type type: str | unicode
        :type name: str | unicode | None
        :rtype: parallels.core.reports.persistent_report_writer.PersistentSubreportWriter
        """
        child_reports = [report.subtarget(type, name) for report in self._reports]
        return MultiReportWriter(*child_reports)

    def append_report(self, report):
        """Add one more report to redirect function calls to

        :type report: parallels.core.reports.report_writer.ReportWriter
        :rtype: None
        """
        self._reports.append(report)
