from parallels.core.utils.paths import web_paths
from parallels.core.utils.paths.copy_web_content import BaseWebPathConverter
from parallels.core import messages


class FtpWebPathConverter(BaseWebPathConverter):
    """Class to convert abstract path descriptor to concrete absolute path on source ftp server"""

    def expand(self, path, server):
        """Convert abstract path descriptor to concrete absolute path for source ftp server

        :type path: parallels.core.utils.web_paths.WebHostingPath
        :rtype: str | unicode
        """
        if isinstance(path, web_paths.AbsolutePath):
            return path.absolute_path
        else:
            assert False, messages.UNSUPPORTED_SOURCE_WEB_PATH_TYPE
