from parallels.core.hosting_repository.database import DatabaseModel
from parallels.plesk.hosting_repository.base import PleskBaseModel
from parallels.plesk.hosting_repository.utils.cli.database import DatabaseCreateCli, DatabaseRegisterCli
from parallels.plesk.hosting_repository.utils.db import db_query


class PleskDatabaseModel(DatabaseModel, PleskBaseModel):
    def create_from_dump(self, database_dump, subscription_name, is_assimilate=False):
        """Create database in target Plesk

        :type database_dump: parallels.core.dump.data_model.Database
        :type subscription_name: str
        :type is_assimilate: bool
        """
        if is_assimilate:
            command = DatabaseRegisterCli(
                runner=self.plesk_cli_runner,
                database_name=database_dump.name,
                database_type=database_dump.dbtype,
                database_host=database_dump.host,
                database_port=database_dump.port,
                subscription_name=subscription_name
            )
        else:
            command = DatabaseCreateCli(
                runner=self.plesk_cli_runner,
                database_name=database_dump.name,
                database_type=database_dump.dbtype,
                database_host=database_dump.host,
                database_port=database_dump.port,
                subscription_name=subscription_name
            )
        command.run()

    def is_exists(self, database_name):
        """Check if database with given name exists in target Plesk

        :type database_name: str
        :rtype: bool
        """
        result = db_query(self.plesk_server, 'SELECT id FROM data_bases WHERE name = %(database_name)s', dict(
            database_name=database_name
        ))
        return len(result) > 0
