from parallels.core.hosting_repository.panel import PanelModel
from parallels.core.registry import Registry
from parallels.core.utils import plesk_utils
from parallels.plesk.hosting_repository.base import PleskBaseModel


class PleskPanelModel(PanelModel, PleskBaseModel):
    def refresh_components(self):
        """Initiate update of cached data about installed target Plesk components; after that target Plesk should
        have an up-to-date info about installed components and ready to perform any capability checking
        """
        plesk_server = Registry.get_instance().get_context().conn.target.plesk_server
        if not plesk_server.is_windows():
            # components data is always up-to-date on unix
            return

        plesk_utils.refresh_node_components(plesk_server)

    def is_service_plan_addon_available(self):
        """Return True in target Plesk is able to manipulate with service plan add-ons

        :rtype: bool
        """
        return True
