from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class ClientPrefUpdateLocaleCli(BaseCli):
    def __init__(self, runner, username, locale):
        """Construct command to update locale of customer with given username in Plesk via CLI

        :type runner: parallels.core.utils.plesk_cli_runner.PleskCLIRunnerBase
        :type username: str
        :type locale: str
        """
        super(ClientPrefUpdateLocaleCli, self).__init__(runner)
        self._username = username
        self._locale = locale

    @property
    def name(self):
        return 'client_pref'

    def _get_args(self):
        return [
            '--update', self._username,
            '-locale', self._locale
        ]
