# coding=utf-8
from parallels.core.utils.message_utils import single_line_message, multi_line_message, load_overrides

ACTION_CONVERT_AUXILIARY_USER_ROLES_DESCRIPTION = single_line_message("""
    Convert auxiliary user roles
""")
ACTION_CONVERT_AUXILIARY_USER_ROLES_FAILURE = single_line_message("""
    Failed to convert auxiliary user roles
""")
ACTION_CONVERT_AUXILIARY_USERS = single_line_message("""
    Convert auxiliary users
""")
ACTION_CONVERT_AUXILIARY_USERS_FAILURE = single_line_message("""
    Failed to convert auxiliary users
""")

ACTION_CREATE_HOSTING_PLANS = single_line_message("""
    Create hosting plans
""")
ACTION_CREATE_HOSTING_PLANS_FAILED = single_line_message("""
    Failed to create hosting plans
""")
ACTION_CREATE_HOSTING_PLANS_PLAN_FAILED = single_line_message("""
    Failed to create hosting plan '{hosting_plan_name}'
""")
ACTION_CREATE_HOSTING_PLANS_ADMIN_PLAN_EXISTS = single_line_message("""
    Hosting plan '{hosting_plan_name}' owned by administrator already exists in target panel
""")
ACTION_CREATE_HOSTING_PLANS_RESELLER_PLAN_EXISTS = single_line_message("""
    Hosting plan '{hosting_plan_name}' owned by '{reseller_username}' already exists in target panel
""")
ACTION_CREATE_HOSTING_PLANS_CREATE_ADMIN_PLAN = single_line_message("""
    Create hosting plan '{hosting_plan_name}' for administrator
""")
ACTION_CREATE_HOSTING_PLANS_CREATE_RESELLER_PLAN = single_line_message("""
    Create hosting plan '{hosting_plan_name}' for '{reseller_username}'
""")

ACTION_DEPLOY_DOMAINS = single_line_message("""
    Deploy add-on domains
""")
ACTION_DEPLOY_DOMAINS_FAILED = single_line_message("""
    Failed to deploy add-on domains of subscription '{subscription_name}'
""")
ACTION_DEPLOY_DOMAINS_REMOVE_COINCIDING_DNS_RECORDS = single_line_message("""
    There are DNS record(s) within the subscription '{subscription_name}' on the target panel, which coincides
    with the name of the domain '{domain_name}'; such DNS record(s) will be removed
""")
ACTION_DEPLOY_DOMAINS_REMOVE_COINCIDING_DNS_RECORDS_REMOVE = single_line_message("""
    Remove the DNS record '{dns_record_pretty_name}' for domain '{dns_record_domain_name}'
    within the subscription '{subscription_name}' from the target panel
""")
ACTION_DEPLOY_DOMAINS_REMOVE_COINCIDING_DNS_RECORDS_REMOVE_ERROR = single_line_message("""
    Unable to remove the DNS record '{dns_record_pretty_name}' for domain '{dns_record_domain_name}' within the
    subscription '{subscription_name}' from the target panel, see debug log for details; it could block
    the creation of the domain '{domain_name}'; in such case you need to remove this DNS record
    manually and then migrate the subscription again
""")
ACTION_DEPLOY_DOMAINS_CREATE_DOMAIN = single_line_message("""
    Create add-on domain '{domain_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_DOMAINS_CREATE_DOMAIN_EXISTS = single_line_message("""
    Domain '{domain_name}' already exists or domain with guid '{domain_guid}' already exists, so skip it'
""")
ACTION_DEPLOY_DOMAINS_CREATE_DOMAIN_ERROR = single_line_message("""
    Unable to create add-on domain '{domain_name}' in subscription '{subscription_name}', see debug log for details'
""")
ACTION_DEPLOY_DOMAINS_SET_FORWARDING = single_line_message("""
    Set forwarding on add-on domain '{domain_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_DOMAINS_SET_FORWARDING_ERROR = single_line_message("""
    Unable to set forwarding on add-on domain '{domain_name}' in subscription '{subscription_name}',
    see debug log for details'
""")
ACTION_DEPLOY_DOMAINS_SET_FORWARDING_ERROR_MISSED_URL = single_line_message("""
    Unable to set forwarding on add-on domain '{domain_name}' in subscription '{subscription_name}'
    because forwarding url is missed in source dump'
""")
ACTION_DEPLOY_DOMAINS_SET_PHYSICAL_HOSTING = single_line_message("""
    Set physical hosting on add-on domain '{domain_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_DOMAINS_SET_PHYSICAL_HOSTING_ERROR = single_line_message("""
    Unable to set physical hosting on add-on domain '{domain_name}' in subscription '{subscription_name}',
    see debug log for details'
""")

ACTION_DEPLOY_SUBDOMAINS = single_line_message("""
    Deploy subdomains
""")
ACTION_DEPLOY_SUBDOMAINS_FAILED = single_line_message("""
    Failed to deploy subdomains of subscription '{subscription_name}'
""")
ACTION_DEPLOY_SUBDOMAINS_CREATE_SUBDOMAIN = single_line_message("""
    Create subdomain '{subdomain_name}' for domain '{domain_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_SUBDOMAINS_CREATE_SUBDOMAIN_EXISTS = single_line_message("""
    Subdomain '{subdomain_name}' already exists or subdomain with guid '{subdomain_guid}' already exists, so skip it'
""")
ACTION_DEPLOY_SUBDOMAINS_CREATE_SUBDOMAIN_ERROR = single_line_message("""
    Unable to create subdomain '{subdomain_name}' in subscription '{subscription_name}', see debug log for details'
""")
ACTION_DEPLOY_SUBDOMAINS_SET_FORWARDING = single_line_message("""
    Set forwarding on subdomain '{subdomain_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_SUBDOMAINS_SET_FORWARDING_ERROR = single_line_message("""
    Unable to set forwarding on subdomain '{subdomain_name}' in subscription '{subscription_name}',
    see debug log for details'
""")
ACTION_DEPLOY_SUBDOMAINS_SET_FORWARDING_ERROR_MISSED_URL = single_line_message("""
    Unable to set forwarding on subdomain '{subdomain_name}' in subscription '{subscription_name}'
    because forwarding url is missed in source dump'
""")
ACTION_DEPLOY_SUBDOMAINS_SET_PHYSICAL_HOSTING = single_line_message("""
    Set physical hosting on subdomain '{subdomain_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_SUBDOMAINS_SET_PHYSICAL_HOSTING_ERROR = single_line_message("""
    Unable to set physical hosting on subdomain '{subdomain_name}' in subscription '{subscription_name}',
    see debug log for details'
""")

ACTION_DEPLOY_DOMAIN_ALIASES = single_line_message("""
    Deploy domain aliases
""")
ACTION_DEPLOY_DOMAIN_ALIASES_FAILED = single_line_message("""
    Failed to deploy domain aliases of subscription '{subscription_name}'
""")
ACTION_DEPLOY_DOMAIN_ALIASES_CREATE_DOMAIN_ALIAS = single_line_message("""
    Create domain alias '{domain_alias_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_DOMAIN_ALIASES_CREATE_DOMAIN_ALIAS_EXISTS = single_line_message("""
    Domain alias '{domain_alias_name}' already exists, so skip it'
""")
ACTION_DEPLOY_DOMAIN_ALIASES_CREATE_DOMAIN_ALIAS_ERROR = single_line_message("""
    Unable to create domain alias '{domain_alias_name}' for domain '{domain_name}'
    in subscription '{subscription_name}', see debug log for details'
""")

ACTION_DEPLOY_MAIL_ACCOUNTS = single_line_message("""
    Deploy mail accounts
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_FAILED = single_line_message("""
    Failed to deploy mail accounts of subscription '{subscription_name}'
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_CREATE_MAIL_ACCOUNT = single_line_message("""
    Create mail account '{mail_account_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_CREATE_MAIL_ACCOUNT_EXISTS = single_line_message("""
    Mail account '{mail_account_name}' already exists, so skip it'
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_CREATE_MAIL_ACCOUNT_ERROR = single_line_message("""
    Unable to create mail account '{mail_account_name}' in subscription '{subscription_name}',
    see debug log for details'
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_SET_FORWARDING = single_line_message("""
    Set forwarding for mail account '{mail_account_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_SET_FORWARDING_ERROR = single_line_message("""
    Unable to set forwarding for mail account '{mail_account_name}' in subscription '{subscription_name}',
    see debug log for details'
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_SET_FORWARDING_ERROR_NO_ADDRESSES = single_line_message("""
    Unable to set forwarding for mail account '{mail_account_name}' in subscription '{subscription_name}'
    because list of forwarding addresses is missed in source dump'
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_SET_ALIASES = single_line_message("""
    Set aliases for mail account '{mail_account_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_MAIL_ACCOUNTS_SET_ALIASES_ERROR = single_line_message("""
    Unable to set aliases for mail account '{mail_account_name}' in subscription '{subscription_name}',
    see debug log for details'
""")

ACTION_DEPLOY_DATABASES = single_line_message("""
    Deploy databases
""")
ACTION_DEPLOY_DATABASES_FAILED = single_line_message("""
    Failed to deploy databases of subscription '{subscription_name}'
""")
ACTION_DEPLOY_DATABASES_SKIP_EXISTING = single_line_message("""
    Database '{database_name}' already exists, so skip it'
""")
ACTION_DEPLOY_DATABASES_ASSIMILATE_DATABASE = single_line_message("""
    Assimilate database '{database_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_DATABASES_ASSIMILATE_DATABASE_ERROR = single_line_message("""
    Unable to assimilate database '{database_name}' in subscription '{subscription_name}',
    see debug log for details'
""")
ACTION_DEPLOY_DATABASES_CREATE_DATABASE = single_line_message("""
    Create database '{database_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_DATABASES_CREATE_DATABASE_ERROR = single_line_message("""
    Unable to create database '{database_name}' in subscription '{subscription_name}',
    see debug log for details'
""")

ACTION_DEPLOY_DATABASE_USERS = single_line_message("""
    Deploy database users
""")
ACTION_DEPLOY_DATABASE_USERS_FAILED = single_line_message("""
    Failed to deploy database users of subscription '{subscription_name}'
""")
ACTION_DEPLOY_DATABASE_USERS_SKIP_EXISTING = single_line_message("""
    Database user '{database_user_name}' already exists, so skip it'
""")
ACTION_DEPLOY_DATABASE_USERS_ASSIMILATE_DATABASE_USER = single_line_message("""
    Assimilate database user '{database_user_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_DATABASE_USERS_ASSIMILATE_DATABASE_USER_ERROR = single_line_message("""
    Unable to create database user '{database_user_name}' in subscription '{subscription_name}',
    see debug log for details'
""")
ACTION_DEPLOY_DATABASE_USERS_CREATE_DATABASE_USER = single_line_message("""
    Create database user '{database_user_name}' in subscription '{subscription_name}'
""")
ACTION_DEPLOY_DATABASE_USERS_CREATE_DATABASE_USER_ERROR = single_line_message("""
    Unable to create database user '{database_user_name}' in subscription '{subscription_name}',
    see debug log for details'
""")

ACTION_SET_RESELLERS_EXTERNAL_ID = single_line_message("""
    Set External ID for resellers
""")
ACTION_SET_RESELLERS_EXTERNAL_ID_FAILED = single_line_message("""
    Failed to set External ID for resellers
""")
ACTION_SET_RESELLERS_EXTERNAL_ID_RESELLER_NOT_EXISTS_SOURCE = single_line_message("""
    Reseller '{reseller_username}' missed in source panel(s) dump, so unable to retrieve External ID
""")
ACTION_SET_RESELLERS_EXTERNAL_ID_RESELLER_EMPTY = single_line_message("""
    External ID for reseller '{reseller_username}' is empty on source panel, so skip it
""")
ACTION_SET_RESELLERS_EXTERNAL_ID_RESELLER_NOT_EXISTS_TARGET = single_line_message("""
    Reseller '{reseller_username}' not exists on target panel, so skip it
""")
ACTION_SET_RESELLERS_EXTERNAL_ID_RESELLER = single_line_message("""
    Set External ID for reseller '{reseller_username}'
""")
ACTION_SET_RESELLERS_EXTERNAL_ID_RESELLER_FAILED = single_line_message("""
    Failed to set External ID for reseller '{reseller_username}', see debug log for details
""")

ACTION_SET_CUSTOMERS_EXTERNAL_ID = single_line_message("""
    Set External ID for customers
""")
ACTION_SET_CUSTOMERS_EXTERNAL_ID_FAILED = single_line_message("""
    Failed to set External ID for customers
""")
ACTION_SET_CUSTOMERS_EXTERNAL_ID_CUSTOMER_NOT_EXISTS_SOURCE = single_line_message("""
    Customer '{customer_username}' missed in source panel(s) dump, so unable to retrieve External ID
""")
ACTION_SET_CUSTOMERS_EXTERNAL_ID_CUSTOMER_EMPTY = single_line_message("""
    External ID for customer '{customer_username}' is empty on source panel, so skip it
""")
ACTION_SET_CUSTOMERS_EXTERNAL_ID_CUSTOMER_NOT_EXISTS_TARGET = single_line_message("""
    Customer '{customer_username}' not exists on target panel, so skip it
""")
ACTION_SET_CUSTOMERS_EXTERNAL_ID_CUSTOMER = single_line_message("""
    Set External ID for customer '{customer_username}'
""")
ACTION_SET_CUSTOMERS_EXTERNAL_ID_CUSTOMER_FAILED = single_line_message("""
    Failed to set External ID for customer '{customer_username}', see debug log for details
""")

ACTION_SET_SUBSCRIPTION_EXTERNAL_ID = single_line_message("""
    Set External ID for subscription
""")
ACTION_SET_SUBSCRIPTION_EXTERNAL_ID_FAILED = single_line_message("""
    Failed to set External ID for subscription '{subscription_name}'
""")
ACTION_SET_SUBSCRIPTION_EXTERNAL_ID_EMPTY = single_line_message("""
    External ID for subscription '{subscription_name}' is empty on target panel, so skip it
""")
ACTION_SET_SUBSCRIPTION_EXTERNAL_ID_NOT_EXISTS = single_line_message("""
    Subscription '{subscription_name}' not exists on target, so skip it
""")

HOSTING_REPOSITORY_CLI_USELESS = single_line_message("""
    Execution of Plesk utility '{name}' with args '{args}' is useless, so skip it
""")

HOSTING_REPOSITORY_DNS_RECORD_REMOVE_ERROR_NAME = single_line_message("""
    Unable to remove DNS record '{dns_record_pretty_name}' because it is not related to domain '{domain_name}',
    whose zone this record belongs according data retrieved from {source_description}
""")
HOSTING_REPOSITORY_DNS_RECORD_REMOVE_ERROR_UNSUPPORTED_TYPE = single_line_message("""
    Removing of DNS records of type '{dns_record_type}' from Plesk servers is not implemented
""")

MIGRATION_ERROR_PLESK_CREDENTIALS_NOT_SPECIFIED = single_line_message("""
    Unable to access Plesk API on server '{plesk_server}' because Plesk Migrator can not retrieve credentials
    for some reason, see debug log for details; also you can specify required credentials explicitly
    in migration configuration file using plesk-username and plesk-password options
""")
CREATE_SUBSCRIPTION_ERROR = multi_line_message("""
    Unable to create subscription '{subscription_name}'.
    {reason}
""")
UPDATE_SUBSCRIPTION_SET_USERNAME_ERROR = single_line_message("""
    Unable to update username '{username}' for subscription '{subscription_name}'
""")
UPDATE_SUBSCRIPTION_ENABLE_HOSTING_ERROR = single_line_message("""
    Unable to enable hosting for subscription '{subscription_name}'
""")

CONVERTER_PLAN_ALLOWED_HOSTING_PLAN_LIMITS = single_line_message("""
    Allowed hosting plan limits: {hosting_plan_limits}
""")
CONVERTER_PLAN_ALLOWED_HOSTING_PLAN_PERMISSIONS = single_line_message("""
    Allowed hosting plan permissions: {hosting_plan_permissions}
""")
CONVERTER_PLAN_ALLOWED_HOSTING_PLAN_SETTINGS = single_line_message("""
    Allowed hosting plan settings: {hosting_plan_settings}
""")

FAILED_TO_CREATE_SERVICE_TEMPLATES_ON_TARGET = multi_line_message("""
    Failed to create the following plans on target panel:
    %s
    
    Migration will be stopped. Check the log above and debug.log for more details. 
    To continue migration, create these plans manually on target panel, 
    or assign subscriptions to another plans with the help of migration list
""")
HOSTING_ADDON_PLAN = single_line_message("""
    hosting addon plan
""")
HOSTING_PLAN = single_line_message("""
    hosting plan
""")
PLAN_SETTINGS = single_line_message("""
    Plan settings: %s
""")
RESELLER_TITLE = single_line_message("""
    '%s' reseller
""")
PLAN_TITLE = single_line_message("""
    %s '%s' owned by %s
""")
ACTION_CREATE_RESELLER_PLANS = single_line_message("""
    Deploy reseller plans
""")
ACTION_CREATE_RESELLER_PLANS_FAILED = single_line_message("""
    Failed to deploy reseller plans
""")
ACTION_CREATE_RESELLER_PLANS_PLAN_EXISTS = single_line_message("""
    Reseller plan '{reseller_plan_name}' already exists in target panel
""")
ACTION_CREATE_RESELLER_PLANS_PLAN_FAILED = single_line_message("""
    Failed to create reseller plan '{reseller_plan_name}'
""")
CREATE_RESELLER_PLAN_CONVERSION_ERRORS = single_line_message("""
    Unable to continue migration until there are no issues at 'error' level when creating admin's reseller plans. Please
    review the report tree above and fix the errors.
""")
FAILED_TO_CREATE_RESELLER_PLAN_SOLUTION = multi_line_message("""
    Check the log above and debug.log for more details.
    To continue migration, create the plan manually on target panel
    or assign resellers to another plan with the help of migration list.
""")
FAILED_TO_CREATE_RESELLER_PLAN_ISSUE = single_line_message("""
    Failed to create reseller plan '%s': %s
""")
RESELLER_PLANS_CONVERSION_REPORT_TITLE = single_line_message("""
    Admin's reseller plans migration status
""")
TARGET_PLESK_SERVER_TITLE = single_line_message("""
    target Plesk server
""")
TARGET_PLESK_SERVER_TITLE_WITH_IP = single_line_message("""
    target Plesk server (%s)
""")
CLIENT_MAPPED_TO_RESELLER_THAT_DOES_NOT_EXIST_SOLUTION = single_line_message("""
    Create this reseller in destination panel, or map client to some existing reseller
""")
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_RESELLER_SOLUTION = single_line_message("""
    Fix migration list so customer belongs to the actual reseller
""")
DEBUG_CLIENT_IS_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
    Client '%s' is not listed in migration list, not including it into target model
""")
CREATE_TARGET_MODEL_OBJECTS = single_line_message("""
    Form up target model objects based on migration dumps
""")
DEBUG_SUBSCRIPTION_NOT_LISTED_IN_MIGRATION_LIST = single_line_message("""
    Subscription '%s' is not listed in migration list, not including it into target model
""")
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_RESELLER_ISSUE = single_line_message("""
    According to migration list customer belongs to %s, but actually on target panel it belongs to another reseller
""")
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_ADMIN_RESELLER_ISSUE_SOLUTION = single_line_message("""
    Fix migration list so customer belongs to administrator
""")
PLAN_DOES_NOT_EXIST_SOLUTION = single_line_message("""
    Create a service template with this name, or assign subscription to other service template
""")
CUSTOMER_BELONGS_TO_DIFFERENT_OWNER_ADMIN_RESELLER_ISSUE = single_line_message("""
    Customer belongs to administrator on target panel, but according to migration list it belongs to reseller '%s'
""")
RESELLER_TITLE_LOWERCASE = single_line_message("""
    reseller '%s'
""")
PLAN_DOES_NOT_EXIST_ISSUE = single_line_message("""
    {owner} does not have a service template named '{plan_name}', unable to make a subscription on it.
    Subscription will not be transferred.
""")
CONVERT_DUMP = single_line_message("""
    Convert migration dump
""")
CUSTOMER_DOES_NOT_EXIST_ISSUE = single_line_message("""
    Customer '%s' does not exist in source or in destination panel, subscription will not be transferred.
""")
CUSTOMER_DOES_NOT_EXIST_ISSUE_SOLUTION = single_line_message("""
    Create the customer with such login manually, or map subscription to any other existing customer.
""")
CLIENT_MAPPED_TO_RESELLER_THAT_DOES_NOT_EXIST_ISSUE = single_line_message("""
    Client is mapped to an reseller '%s' which does not exist
""")
NO_SUCH_ADMIN_RESELLER_PLAN_ISSUE = single_line_message("""
    Reseller plan '%s' specified in migration list file does not exist
""")
NO_SUCH_ADMIN_RESELLER_PLAN_SOLUTION = single_line_message("""
    Fix migration list so existing plan is used, or create reseller plan with such name
""")
ADMIN_RESELLER_PLAN_ON_MULTIPLE_SOURCES_ISSUE = single_line_message("""
    Reseller plan '%s' exists on multiple source panels. Plan from '%s' will be used
    during migration
""")
LOG_RESELLER_ADMIN_PLAN_ALREADY_EXISTS = single_line_message("""
    Reseller plan '%s' already exists on target panel, it will be used during migration
""")
LOG_CONVERT_SOURCE_PANEL_ADMIN_RESELLER_PLANS = single_line_message("""
    Convert source panel's admin's reseller plans
""")
LOG_MERGE_ADMIN_RESELLER_PLANS = single_line_message("""
    Merge admin's reseller plans
""")
LOG_CONVERT_TARGET_ADMIN_RESELLER_PLANS = single_line_message("""
    Convert target panel admin's reseller plans
""")
LOG_CONVERT_ADMIN_RESELLER_PLANS = single_line_message("""
    Convert admin's reseller plans
""")
SKIPPED_CREATING_EXISTING_AUXILIARY_USER = single_line_message("""
    Skipped creating an existing auxuser '%s'.
""")
USER_PASSWORD_DOES_NOT_MEET_PLESK_REQUIREMENTS = single_line_message("""
    User password does not meet Plesk requirements. A temporary password is generated: '%s'
""")
TARGET_PANEL_PLESK_TITLE = single_line_message("""
    Plesk
""")
UNIX_SUBSCRIPTION_REPAIR_WEBSPACE_NOT_APPLICABLE = single_line_message("""
    Repair webspace security is a Windows-specific function and can not be applied to Plesk for Unix
""")
UNIX_SUBSCRIPTION_GET_DEDICATED_APP_POOL_USER_NOT_APPLICABLE = single_line_message("""
    Get dedicated application pool user is a Windows-specific function and can not be applied to Plesk for Unix
""")
UNIX_SUBDOMAIN_UPDATE_SECURITY_METADATA_LOCATION_NOT_APPLICABLE = single_line_message("""
    Update webspace subdomains security metadata location is a Windows-specific function and can not be applied to Plesk
    for Unix
""")
TARGET_PLESK_VERSION_NOT_SUPPORTED = single_line_message("""
    Migration to Plesk %s is not supported. We strongly recommend that you install Plesk 12.0 or later for migration, or
    upgrade the current installation to the latest version. If you still want to migrate to a Plesk version earlier than
    12.0, use the migration tools bundled with Plesk (not recommended).
""")
UNABLE_TO_FIND_DB_SERVER_ON_TARGET_ISSUE = single_line_message("""
    Unable to find %s database server on target panel
""")
LOG_EXCEPTION = single_line_message("""
    Exception:
""")
SUBSCRIPTION_WAS_ALREADY_CREATED = multi_line_message("""
    Subscription already exists on target server: most probably it was created at the previous attempt,
    but migration tools are not sure if it was created correctly.
    It is recommended to:
    1) Resolve the original issue that caused subscription creation to fail,
    delete subscription, and then run migration again.
    OR
    2) Ensure that created subscription is fine, or the original issue is minor,
    then simply run migration for that subscription again.
""")
ACTION_CHECK_TARGET_LICENSE_LIMIT_DESCRIPTION = single_line_message("""
    Check license limits on target Plesk server
""")
ACTION_CHECK_TARGET_LICENSE_LIMIT_FAILURE = single_line_message("""
    Failed to check license limits on target Plesk server
""")
LOG_DOMAINS_ON_TARGET = single_line_message("""
    Domains on target server: {domains_count}
""")
LOG_LICENSE_LIMIT_ON_TARGET = single_line_message("""
    License limit for domains on target server: {domains_count}
""")
LOG_DOMAINS_ON_SOURCE = single_line_message("""
    Domains on source server: {domains_count}
""")
NOT_ENOUGH_DOMAINS_IN_LICENSE_ISSUE = single_line_message("""
    Target Plesk server license has less available domains that required for migration. Number of available domains
    according to license limitations: {available}. Number of domains we are going to migrate: {required}.
""")
NOT_ENOUGH_DOMAINS_IN_LICENSE_SOLUTION = single_line_message("""
    Obtain and install license on target Plesk server that have more domains available.
""")
UNABLE_TO_FIND_CAPABILITY_CHECK_REPORT = single_line_message("""
    Unable to find capability check report %s
""")
UNABLE_TO_FIND_CAPABILITY_DUMP = single_line_message("""
    Unable to find capability dump %s
""")
ACTION_CHECK_CAPABILITY_DESCRIPTION = single_line_message("""
    Check target panel capability
""")
ACTION_CHECK_CAPABILITY_FAILURE = single_line_message("""
    Failed to check capability of target panel
""")
SYNC_SUBSCRIPTION_WITH_PLAN = single_line_message("""
    Synchronize subscription with plan
""")
FAILED_TO_SYNC_SUBSCRIPTION_WITH_PLAN = single_line_message("""
    Failed to synchronize subscription with plan
""")
CHANGE_NO_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
    Change web IP addresses in dump for subscription without virtual hosting
""")
FAILED_TO_CHANGE_NO_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
    Failed to change web IP addresses in dump for subscription without virtual hosting
""")
LOG_WEB_IPS_SET_TO = single_line_message("""
    Subscription '{subscription_name}' web IPs are set to ({ipv4}, {ipv6})
""")
CHECK_MISSING_COMPONENTS_DESCRIPTION = single_line_message("""
    Check for missing Python and Perl components on target Plesk for Windows
""")
CHECK_MISSING_COMPONENTS_FAILURE = single_line_message("""
    Failed to check for missing Python and Perl components on target Plesk for Windows
""")
REMOVE_MISSING_COMPONENTS_DESCRIPTION = single_line_message("""
    Remove missing Python and Perl scripting options from backup dump
""")
REMOVE_MISSING_COMPONENTS_FAILURE = single_line_message("""
    Failed to remove missing Python and Perl scripting options from backup dump
""")
MISSING_COMPONENT_ISSUE = single_line_message("""
    The component {component} is not installed on the destination server. It will be unavailable for
    the following domains: {domains}
""")
MISSING_COMPONENT_SOLUTION = single_line_message("""
    Install that component on the destination server or make sure that none of these
    domains actually need the component.
""")
SUBSCRIPTION_CANNOT_BE_SYNCED_WITH_PLAN_MISSING_COMPONENT = multi_line_message("""
    Subscription cannot be completely synchronized with service plan: the plan has some features enabled which
    can not be activated because some components are not installed. To see which components are missing and how to
    resolve that issue, try to synchronize subscription with service plan in Plesk Panel:
    login to Plesk Panel as administrator, click on subscription, then in "Account" box click "Sync" link.
""")
SERVICE_PLAN_PHP_HANDLER_NOT_AVAILABLE_ISSUE = multi_line_message("""
    Service plan '{plan_name}' on source server has PHP handler
    that is not installed on the target server: {source_php_handler}.
    Another PHP handler was selected for that service template: {target_php_handler}
""")
SERVICE_PLAN_PHP_HANDLER_NOT_AVAILABLE_SOLUTION = multi_line_message("""
    To resolve the issue, it is recommended to do one of the following:
    - Install and enable such PHP handler to target server.
    - Ensure that PHP handler that was selected automatically is fine for migrated web sites.
    - Select appropriate PHP handler in service template once migration is finished
    and synchronize the changes to subscriptions.
""")

ADDON_PLAN_DOES_NOT_EXIST_ISSUE = single_line_message("""
    {owner} does not have an addon plan named '{plan_name}', unable to make a subscription on it.
    Subscription will not be transferred.
""")
ADDON_PLAN_DOES_NOT_EXIST_SOLUTION = single_line_message("""
    Create an addon plan with this name, or assign subscription to other addon plan, or remove addon plan from
    the migration list file
""")
IP_MAPPING_NO_SUCH_IP_SOLUTION = single_line_message("""
    Either add such IP address to the target Plesk server,
    or migrate subscription to another address by specifying '%s: <ip>' in the migration list.
    Also you can change IP address after migration is finished.
""")
IP_MAPPING_IP_ASSIGNED_TO_ANOTHER_OWNER_SOLUTION = single_line_message("""
    Migrate subscription to another address by specifying '%s: <ip>' in the migration list.
    Also you can change IP address after migration is finished.
""")
IP_MAPPING_NO_MORE_EXCLUSIVE_IP_ISSUE = single_line_message("""
    There is not enough free exclusive %s addresses on target Plesk to map all source exclusive IP addresses.
    This subscription will be migrated to default shared IP address
""")
IP_MAPPING_NO_MORE_EXCLUSIVE_IP_SOLUTION = single_line_message("""
    Add more free exclusive IP addresses to target panel
    or change IP addresses of migrated subscriptions after migration
""")
IP_MAPPING_NO_FREE_EXCLUSIVE_IP_SOLUTION = single_line_message("""
    To migrate subscription to exclusive %s, add more free exclusive IP addresses on the target Plesk server.
    Also you can change IP address after migration is finished.
""")
IP_MAPPING_NO_SHARED_IP_ISSUE_ERROR = single_line_message("""
    There is no shared %s address on target Plesk. Subscription can not be migrated.
""")
IP_MAPPING_NO_SHARED_IP_ISSUE_WARNING = single_line_message("""
    There is no shared %s address on target Plesk.
""")
IP_MAPPING_NO_SUCH_IP_ISSUE = single_line_message("""
    Subscription is assigned to %s address '%s' which does not exist on the target Plesk server.
    Subscription will be migrated to default shared IP.
""")
IP_MAPPING_NO_FREE_EXCLUSIVE_IP_ISSUE = single_line_message("""
    Subscription is assigned to exclusive IP address, but there are no free exclusive IP addresses left.
    Subscription will be migrated to default shared IP address.
""")
IP_MAPPING_NO_SHARED_IP_SOLUTION = single_line_message("""
    Fix Plesk configuration so there is at least one shared %s address
""")
IP_MAPPING_IP_ASSIGNED_TO_ANOTHER_OWNER_ISSUE = single_line_message("""
    Subscription is assigned to %s address '%s' which is also assigned to another reseller/client.
    Subscription will be migrated to default shared IP.
""")
ACTION_SET_APACHE_RESTART_INTERVAL = single_line_message("""
    Set Apache restart interval
""")
MIGRATION_TOOL_DETECTED_THAT_OLD_APACHE = single_line_message("""
    The migration tool has detected that the old Apache restart interval was not completely restored, probably because
    the tool was terminated abnormally. The tool will restore this interval (%s) upon completing the transfer.
""")
SET_APACHE_RESTART_INTERVAL_S_SECONDS = single_line_message("""
    Set Apache restart interval to %s seconds
""")
ACTION_CONVERT_DNS_RECORDS = single_line_message("""
    Convert DNS records
""")
IP_MAPPING_ASSIGNED_DEFAULT_IP = single_line_message("""
    Assigned a default shared IP address '%s' to the subscription '%s'
""")
IP_MAPPING_SUBSCRIPTION_ASSIGNED_IPS = single_line_message("""
    Subscription IP is set to ("%s", "%s"), as specified in the migration list.
""")
FAILED_TO_ADD_IP_TO_RESELLER_POOL = single_line_message("""
    Failed to add IP address '%s' to IP pool of reseller '%s':
    ip_pool utility returned non-zero exit code. Utility stdout: %s, stderr: %s"
""")
ACTION_IMPORT_RESELLERS = single_line_message("""
    Import resellers
""")
FAILED_SET_APACHE_RESTART_INTERVAL_VALUE = single_line_message("""
    Failed to set Apache restart interval value to %s seconds
""")
IMPORT_SET_LOCALE_FAILED = multi_line_message("""
    Failed to set locale {locale}: {error}

    Default locale will be used. Make sure you can set the locale manually from Plesk user interface.
    Typical reasons of that issue are:
    1. License limitations - you do not have specified locale in your license key.
    2. Locale is disabled at "Tools & Settings" - "Languages".
""")
LOG_TARGET_PLESK_SERVER = single_line_message("""
    Target Plesk host: {ip_address}
""")
FAILED_TO_GET_CUSTOMER_ID = single_line_message("""
    Failed to get ID of created customer '{login}'
""")
FAILED_TO_GET_RESELLER_ID = single_line_message("""
    Failed to get ID of created reseller '{login}'
""")
FAILED_TO_SET_CUSTOMER_CONTACT_DATA = multi_line_message("""
    Failed to set contact data for customer '{login}': {reason}.

    Please update contact data manually for that customer on the target server.
""")
FAILED_TO_SET_RESELLER_CONTACT_DATA = multi_line_message("""
    Failed to set contact data for reseller '{login}': {reason}.

    Please update contact data manually for that reseller on the target server.
""")
FAILED_TO_SET_RESELLER_PREFS = multi_line_message("""
    Failed to set limits and permissions of reseller '{login}': {reason}.

    Please set them manually after migration.
""")
ACTION_CHECK_PLESKS_VERSIONS_DESCRIPTION = single_line_message("""
    Check migration compatibility of source and target Plesk versions
""")
ACTION_CHECK_PLESKS_VERSIONS_FAILURE = single_line_message("""
    Failed to check migration compatibility of source and target Plesk versions
""")
FAILURE_TARGET_VERSION_IS_LOWER = single_line_message("""
    Version of Plesk on the target server ({target_version})
    is lower than version of Plesk on the source server '{source_id}' ({source_version}).
    Migration to lower version of Plesk is not supported by migration tool.
""")
ACTION_CHECK_PLESKS_COMPONENTS_DESCRIPTION = single_line_message("""
    Check that all required components are installed on source Plesk
""")
ACTION_CHECK_PLESKS_COMPONENTS_FAILURE = single_line_message("""
    Failed to check that all required components are installed on source Plesk
""")
FAILURE_NO_BACKUP_MANAGER = multi_line_message("""
    Plesk Backup Manager required for migration is not installed to {server}.
    Please install it and then restart migration.

    To install it:
    1. Login to the source control panel as admin user.
    2. Go to "Tools & Settings" - "Updates and Upgrades".
    3. Click "Add Components".
    4. Put check on "Server backup solutions" - "Plesk Backup Manager".
    5. Click "Continue" and follow the instructions.
""")
ACTION_ADJUST_APPLICATIONS_DESCRIPTION = single_line_message("""
    Adjust common migrated applications for new environment
""")
ACTION_ADJUST_APPLICATIONS_FAILURE = single_line_message("""
    Failed to adjust common migrated applications for new environment
""")
COMMAND_FIX_APPLICATIONS = single_line_message("""
    Fix applications migrated to target server: update database connections strings and so on.
""")
ACTION_PRINT_ADJUST_REPORT_DESCRIPTION = single_line_message("""
    Print application adjust report
""")
ACTION_PRINT_ADJUST_REPORT_FAILURE = single_line_message("""
    Failed to print application adjust report
""")
FAILED_TO_SET_RESELLER_FIELDS = multi_line_message("""
    Failed to set the following data for reseller '{login}' on the target server:
    {fields}

    Most probable reason is that these fields do not conform to Plesk rules.
    If you actually need, you can update these fields manually for that reseller on the target server.
    All of them (except for passwords) are appended to "Additional information" field in the target server,
    so you don't loose any information.
""")
FAILED_TO_SET_CUSTOMER_FIELDS = multi_line_message("""
    Failed to set the following data for customer '{login}' on the target server:
    {fields}

    Most probable reason is that these fields do not conform to Plesk rules.
    If you actually need, you can update these fields manually for that customer on the target server.
    All of them (except for passwords) are appended to "Additional information" field in the target server,
    so you don't loose any information.
""")
DEBUG_START_ADJUST_DATABASE = single_line_message("""
    Start adjust database connection settings in configuration files of subscription
""")
DEBUG_END_ADJUST_DATABASE = single_line_message("""
    End adjust database connection settings in configuration files of subscription
""")
DEBUG_START_ADJUST_PATHS = single_line_message("""
    Start adjust paths in configuration and code files of subscription
""")
DEBUG_END_ADJUST_PATHS = single_line_message("""
    End adjust paths in configuration and code files of subscription
""")
ACTION_FIX_WEB_CONFIG_DOT_NET_2_TO_4_DESCRIPTION = single_line_message("""
    Fix web.config files when switching from .NET 2-3.5 to .NET 4
""")
ACTION_FIX_WEB_CONFIG_DOT_NET_2_TO_4_FAILURE = single_line_message("""
    Failed to fix web.config files when switching from .NET 2-3.5 to .NET 4
""")
DEBUG_SKIP_BINARY_FILE_FIXING_WEB_CONFIG_DOT_NET_2_TO_4 = single_line_message("""
    File {filename} was skipped when fixing web.config files switching from .NET 2-3.5 to NET 4:
    it looks like a binary file, or has not-UTF-8 encoding
""")
DEBUG_SKIP_INVALID_XML_WEB_CONFIG_DOT_NET_2_TO_4 = single_line_message("""
    File {filename} was skipped when fixing web.config files switching from .NET 2-3.5 to NET 4:
    failed to parse it as XML. Check if it is a well-formed XML document.
""")
UPGRADED_WEB_CONFIG_FILE = multi_line_message("""
    Upgraded web.config file '{filename}', so it could work with .NET 4:
    removed 'system.web.extensions' section, which has definitions that already
    exist in root web configuration files for .NET 4.
""")
SUBSCRIPTION_DOES_NOT_EXIST_ON_SOURCE = multi_line_message("""
    Subscription '{subscription}' does not exists on source server(s).
    Probably it was removed from the source server since migration was started.
    Migration of that subscription will be skipped.
""")
FAILED_TO_FIND_SUBSCRIPTION_IN_DUMP = single_line_message("""
    Failed to find subscription '%s' in hosting description file
""")
FAILED_TO_FIND_DB_SERVER = single_line_message("""
    Failed to find database server with ID '{db_server_id}' in configuration file
""")
REMOVING_EXISTING_DUMP_DIR = single_line_message("""
    Removing the existing Plesk configuration dump directory.
""")
INVALID_FILE_FORMAT = single_line_message("""
    Invalid file file format specified for hosting description file '%s'.
    Please specify one of: 'yaml', 'json', 'xml'.
""")
HOSTING_DESCRIPTION_FILE_DOES_NOT_EXIST = multi_line_message("""
    Hosting description file '{filename}' does not exists.
    Set correct path to hosting description file in configuration file.
""")
HOSTING_DESCRIPTION_FILE_READ_IO_ERROR = multi_line_message("""
    Failed to read hosting description file '{filename}':
    {reason}

    Set correct path to hosting description file in configuration file and check that it has correct permissions
    so migration tool can read it.
""")
HOSTING_DESCRIPTION_FILE_READ_ERROR = multi_line_message("""
    Failed to read hosting description file '{filename}':
    {reason}

    Check that it has correct syntax for {format}, fix it and start migration tool again.
""")
FAILED_TO_FIND_ADDON_IN_DUMP = single_line_message("""
    Failed to find addon domain '%s' in hosting description file
""")
FAILED_TO_FIND_SUBDOMAIN_IN_DUMP = single_line_message("""
    Failed to find subdomain '%s' in hosting description file
""")
INVALID_BOOLEAN_VALUE = single_line_message("""
    Invalid boolean value '%s'. Expected one of: 1/0/on/off/true/false/enabled/disabled
""")
INVALID_TAG = single_line_message("""
    Invalid tag: %s. Expected: %s
""")
VALIDATOR_EXPECTED_BOOLEAN_VALUE = single_line_message("""
    Expected boolean value
""")
VALIDATOR_EXPECTED_DICT_VALUE = single_line_message("""
    Expected dictionary value
""")
VALIDATOR_LIST_VALUE_EXPECTED = single_line_message("""
    Expected list value
""")
VALIDATOR_INVALID_DATA = single_line_message("""
    Invalid data is specified
""")
VALIDATOR_EXPECTED_STRING = single_line_message("""
    Expected string value
""")
VALIDATOR_STRUCT_KEY_NOT_EXPECTED = single_line_message("""
    Key '{key}' not expected. Expected one of: {expected_list}
""")
VALIDATOR_STRUCT_REQUIRED_KEY_NOT_SPECIFIED = single_line_message("""
    Required element '{key}' is not specified
""")
SUBSCRIPTION_TITLE = single_line_message("""
    Subscription '{subscription}'
""")
ADDON_DOMAIN_TITLE = single_line_message("""
    Subscription '{subscription}', addon domain '{addon_domain}'
""")
SUBDOMAIN_TITLE = single_line_message("""
    Subscription '{subscription}', subdomain '{subdomain}'
""")
VALIDATION_INVALID_FORWARDING_TYPE = single_line_message("""
    {domain_description}:
    invalid forwarding type '{forwarding_type}' was specified.
    Allowed values: {allowed_values}.
""")
VALIDATION_FORWARDING_TYPE_WITH_NO_URL = single_line_message("""
    {domain_description}:
    forwarding type was specified, but forwarding URL was not.
    Specify valid forwarding URL with 'forwarding-url' option.
""")
MULTIPLE_HOSTINGS_SPECIFIED = multi_line_message("""
    {domain_description}:
    Multiple hosting types are specified. Please specify only one hosting type:
    (*) virtual hosting ('target_document_root' attribute)
    (*) forwarding ('forwarding_url' and 'forwarding_type' attributes)
    (*) no web hosting ('no_web_hosting' attribute)
""")
VALIDATION_NON_ASCII_DOCUMENT_ROOT = single_line_message("""
    {domain_description}:
    invalid document root '{document_root}' was specified.
    Document root of a site in Plesk must consist only of ASCII symbols
""")
FORWARDING_SUBSCRIPTION_WITH_SITES = multi_line_message("""
    Subscription '{subscription}' has forwarding hosting type and several sites: {sites}.
    That is invalid configuration for target server: subscription should have virtual
    hosting type to host addon domains and subdomains.
""")
NO_HOSTING_SUBSCRIPTION_WITH_SITES = multi_line_message("""
    Subscription '{subscription}' has no virtual hosting and several sites: {sites}.
    That is invalid configuration for target server: subscription should have virtual
    hosting type to host addon domains and subdomains.
""")
VALIDATION_NO_SUCH_PARENT_DOMAIN = single_line_message("""
    Subscription '{subscription}', subdomain '{subdomain}':
    'parent_domain' attribute has invalid value '{parent_domain}'.
    It should be equal to one of domains of subscription: {list_of_domains}
""")
VALIDATION_PARENT_DOMAIN_NOT_FOUND = single_line_message("""
    Subscription '{subscription}', subdomain '{subdomain}':
    parent domain is not found for that subdomain among subscription's domains.
    Here is a list of all subscription's domains: {list_of_domains}. Either make
    the subdomain ends with one of these domain names, or if you want to use short subdomain name,
    then specify parent domain with 'parent_domain' attribute.
""")
VALIDATION_INVALID_MAILBOX_NAME = single_line_message("""
    Subscription '{subscription}', mailbox '{mailbox}':
    The name of the mailbox should not contain '@' symbol
""")
VALIDATION_INVALID_IPV4_ADDRESS = single_line_message("""
    Subscription '{subscription}':
    specified mail service IPv4 address '{ip}' is not valid IPv4 address
""")
VALIDATION_INVALID_IPV6_ADDRESS = single_line_message("""
    Subscription '{subscription}':
    specified mail service IPv6 address '{ip}' is not valid IPv6 address
""")
VALIDATION_INVALID_MAILBOX_LIMIT = single_line_message("""
    Subscription '{subscription}', mailbox '{mailbox}':
    Invalid limit '{limit}' is specified. It should be specified as bytes count (for example '10000000'),
    as kilobytes count (for example '10000K') or megabytes count (for example '10M'). Also, unlimited
    value could be specified with a special value "-1".
""")
VALIDATION_INVALID_DATABASE_TYPE = single_line_message("""
    Subscription '{subscription}', database '{database}':
    Invalid database type '{database_type}' is specified. Specify either 'mysql' or 'mssql'
""")
VALIDATE_NO_SUCH_DATABASE_SERVER = single_line_message("""
    Subscription '{subscription}', database '{database}':
    Database server '{db_server_id}' is not specified in configuration file.
    Check that database server ID is spelled correctly, or add database server with such ID to
    Plesk Migrator's configuration file
""")
VALIDATION_FILES_MAILBOX_DIR_NOT_EXIST = single_line_message("""
    Subscription '{subscription}', mailbox '{mailbox}':
    directory '{directory}' with mail messages does not exist on {server}
""")
VALIDATION_FILES_MAILBOX_DIR_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}', mailbox '{mailbox}':
    this type of migration does not allow to specify directory with mail messages
""")
VALIDATION_MAIL_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}':
    mail server '{mail_server}' is not specified in configuration file of Plesk Migrator, but specified
    in hosting description file as subscription's mail server. Check spelling or specify mail server in
    configuration file.
""")
VALIDATION_FILES_DB_DUMP_NOT_EXIST = single_line_message("""
    Subscription '{subscription}', database '{database}':
    database dump file '{file}' does not exist on the current server
""")
VALIDATION_FILES_SUBSCRIPTION_WEBSPACE_ROOT_NOT_EXIST = single_line_message("""
    Subscription '{subscription}':
    source webspace root '{source_webspace_root}' specified in hosting description file does not exist on {server}
""")
VALIDATION_FILES_SUBSCRIPTION_WEBSPACE_ROOT_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}':
    this type of migration does not allow to specify source webspace root
""")
VALIDATION_FILES_SUBSCRIPTION_DOC_ROOT_NOT_EXIST = single_line_message("""
    Subscription '{subscription}':
    source document root '{source_document_root}' specified in hosting description file does not exist on {server}
""")
VALIDATION_FILES_SUBSCRIPTION_DOC_ROOT_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}':
    this type of migration does not allow to specify source document root
""")
VALIDATION_FILES_ADDON_DOMAIN_DOC_ROOT_NOT_EXIST = single_line_message("""
    Subscription '{subscription}', addon domain '{addon_domain}':
    source document root '{source_document_root}' specified in hosting description file does not exist on {server}
""")
VALIDATION_FILES_ADDON_DOMAIN_DOC_ROOT_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}', addon domain '{addon_domain}':
    this type of migration does not allow to specify source document root
""")
VALIDATION_SUBDOMAIN_DOC_ROOT_NOT_EXIST = single_line_message("""
    Subscription '{subscription}', subdomain '{subdomain}':
    source document root '{source_document_root}' specified in hosting description file does not exist on {server}
""")
VALIDATION_SUBDOMAIN_DOC_ROOT_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}', subdomain '{subdomain}':
    this type of migration does not allow to specify source document root '{source_document_root}'
""")
VALIDATION_FILES_WEB_FILE_FOR_SUBSCRIPTION_NOT_EXIST = single_line_message("""
    Subscription '{subscription}': web file '{filename}' does not exist on {server}
""")
VALIDATION_FILES_WEB_FILE_FOR_SUBSCRIPTION_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}': this type of migration does not allow to specify web files
""")
VALIDATION_FILES_WEB_FILE_FOR_ADDON_DOMAIN_NOT_EXIST = single_line_message("""
    Subscription '{subscription}', addon domain '{addon_domain}': web file '{filename}' does not exist on {server}
""")
VALIDATION_FILES_WEB_FILE_FOR_ADDON_DOMAIN_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}', addon domain '{addon_domain}':
    this type of migration does not allow to specify web files
""")
VALIDATION_FILES_WEB_FILE_FOR_SUBDOMAIN_NOT_EXIST = single_line_message("""
    Subscription '{subscription}', subdomain '{subdomain}': web file '{filename}' does not exist on {server}
""")
VALIDATION_FILES_WEB_FILE_FOR_SUBDOMAIN_SERVER_NOT_SPECIFIED = single_line_message("""
    Subscription '{subscription}', subdomain '{subdomain}':
    this type of migration does not allow to specify web files
""")

# Load language and UI type overrides. That must be the last line of root messages file.
load_overrides(__name__, locals())
