import posixpath

from parallels.core.utils.common_constants import UNIX_SOURCE_DEFAULT_SESSION_DIR
from parallels.core.utils.config_utils import ConfigSection
from parallels.core.migrator_config import read_ssh_auth, SourceUnixServerConfig
from parallels.core.migrator_config import read_copy_mail_content_settings

# This is the ID used for naming config file sections and migration dump files
PANEL_ID = 'cpanel'


class CpanelConfig(SourceUnixServerConfig):
    def __init__(self, config_section):
        """Class constructor

        :type config_section: parallels.core.utils.config_utils.ConfigSection
        """
        ip = config_section['ip']
        ssh_auth = read_ssh_auth(config_section)
        session_dir = config_section.get('session-dir', UNIX_SOURCE_DEFAULT_SESSION_DIR)
        mail_settings = read_copy_mail_content_settings(
            config_section, is_windows=False
        )
        SourceUnixServerConfig.__init__(
            self, config_section, PANEL_ID, ip, session_dir, ssh_auth, mail_settings
        )

        self.postgres_password = config_section.get_password('postgres-password')
        self.pmm_agent_name = "cPanel"
        self.agent_script_name = 'cPanel9.pl'
        self.agent_home = posixpath.join(self.session_dir, 'migration_agent')


def init(config):
    cpanel_section = ConfigSection(config, PANEL_ID)
    return CpanelConfig(cpanel_section)

