from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.content.web.copy_unix_content_base import CopyUnixWebContent
from parallels.core.actions.utils.logging_properties import LoggingProperties
from parallels.core.utils.backup_adapter import SubscriptionBackup
from parallels.plesk.source.cpanel import messages
from parallels.core.actions.base.legacy_action import LegacyAction
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.core.actions.content.web.fix_unix_htaccess import FixUnixHtaccess
from parallels.core.actions.content.web.fix_unix_vhost_permissions import FixUnixVhostPermissions
from parallels.plesk.source.cpanel.actions.content.web.fix_unix_permissions import FixUnixPermissions
from parallels.plesk.source.cpanel.actions.fix_spamassassin_patterns import FixSpamassassinPatterns


class WorkflowExtension(WorkflowExtensionBase):
    def extend_workflow(self, workflow):
        """Extend shared hosting workflow with source-panel specific actions

        :type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
        """
        workflow.replace_shared_action('fetch-source-shallow', CompoundAction())
        for fetch_action in ('fetch-source', 'fetch-source-shallow'):
            workflow.get_shared_action(fetch_action).insert_action(
                'fetch-data', LegacyAction(
                    description=messages.ACTION_FETCH_SOURCE,
                    function=lambda ctx: ctx.migrator._fetch_source(
                        ctx.options, ctx.options.reload_source_data
                    ),
                    logging_properties=LoggingProperties(info_log=False)
                )
            )
        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-files', CopyUnixWebContent()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'fix-unix-htaccess', FixUnixHtaccess()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'fix-unix-vhost-permissions', FixUnixVhostPermissions()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'fix-permissions', FixUnixPermissions()
        )
        workflow.get_shared_action('convert-hosting').insert_action(
            'fix-spamassassin-patterns', FixSpamassassinPatterns(SubscriptionBackup()),
            before='save-backup'
        )
