from parallels.plesk.source.expand import messages
from parallels.plesk.source.plesk.actions.fetch.fetch_backup import FetchBackupActionBase


class FetchCentralizedMailBackupAction(FetchBackupActionBase):
    def get_description(self):
        return messages.ACTION_FETCH_DATA_FROM_CMAIL_DESCRIPTION

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_FETCH_DATA_FROM_CMAIL_FAILURE

    @staticmethod
    def _get_source_servers(global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return global_context.conn.get_centralized_mail_servers()
