from parallels.core.cli.common_cli import Command, CommandTypes
from parallels.core.cli.extension import CLIExtensionBase
from parallels.plesk.source.helm3 import messages


class CLIExtension(CLIExtensionBase):
    """Command line migrator interface extension for source custom panel"""

    def get_additional_commands(self, common_options):
        """
        :type common_options: parallels.core.cli.migration_cli.CommonMigrationOptions
        :rtype: list[parallels.core.cli.common_cli.Command]
        """
        return [
            Command(
                'check-helm-nodes', CommandTypes.INTERNAL,
                messages.CLI_CHECK_HELM_NODES,
                lambda runner: runner.run_entry_point('check-helm-nodes'),
                common_options.global_options_list + common_options.post_migration_options_list
            ),
        ]