from parallels.core.global_context import GlobalMigrationContext
from parallels.plesk.source.helm3.helm3_agent import Helm3Agent
from parallels.core.utils.common import cached


class Helm3GlobalMigrationContext(GlobalMigrationContext):
    """
    :type session_files: parallels.plesk.source.helm3.session_files.Helm3SessionFiles
    """
    def __init__(self):
        self.session_files = None
        super(Helm3GlobalMigrationContext, self).__init__()

    @property
    @cached
    def helm3_agent(self):
        return Helm3Agent(self.conn.helm3.get_main_source_server())