from parallels.core.utils.entity import Entity


class Template(Entity):
    def __init__(self, template_id, guid, owner_id, template_type, name):
        self._template_id = template_id
        self._guid = guid
        self._owner_id = owner_id
        self._template_type = template_type
        self._name = name

    @property
    def template_id(self):
        """
        :rtype: str | unicode
        """
        return self._template_id

    @property
    def guid(self):
        """
        :rtype: str | unicode
        """
        return self._guid

    @property
    def owner_id(self):
        """
        :rtype: str | unicode
        """
        return self._owner_id

    @property
    def template_type(self):
        """
        :rtype: str | unicode
        """
        return self._template_type

    @property
    def name(self):
        """
        :rtype: str | unicode
        """
        return self._name

    @property
    def is_addon(self):
        """
        :rtype: str | unicode
        """
        return 'true' if self.template_type == 'domain_addon' else 'false'
