from parallels.core import MigrationError
from parallels.plesk.source.plesk import messages
from parallels.plesk.source.plesk.hosting_description.provider.plesk import PleskHostingDescriptionProvider
from parallels.plesk.source.plesk.hosting_description.provider.plesk_125 import PleskHostingDescriptionProvider125
from parallels.plesk.source.plesk.hosting_description.provider.plesk_170 import PleskHostingDescriptionProvider170


def create_plesk_hosting_description_provider(dump_agent, selection):
    """Create corresponding hosting description dump model by Plesk version

    :type dump_agent: parallels.core.utils.pmm.agent.PmmMigrationAgentBase
    :type selection: parallels.core.utils.pmm.agent.DumpAll | parallels.core.utils.pmm.agent.DumpSelected
    :rtype: parallels.plesk.source.plesk.hosting_description.provider.plesk.PleskHostingDescriptionProvider
    """
    plesk_version = dump_agent.source_server().plesk_version
    major_version = plesk_version[0]
    minor_version = plesk_version[1] if len(plesk_version) > 1 else 0
    if (major_version, minor_version) >= (17, 0):
        return PleskHostingDescriptionProvider170(selection, dump_agent)
    elif (major_version, minor_version) >= (12, 5):
        return PleskHostingDescriptionProvider125(selection, dump_agent)
    elif (major_version, minor_version) >= (12, 0):
        return PleskHostingDescriptionProvider(selection, dump_agent)
    raise MigrationError(
        messages.PLESK_VERSION_NOT_SUPPORTED_BY_HOSTING_DESCRIPTION_DUMP.format(plesk_version='.'.join(map(str, plesk_version)))
    )
