from parallels.plesk.hosting_description.utils import create_dict
from parallels.plesk.source.plesk import messages
from parallels.plesk.source.plesk.hosting_description.provider.plesk import PleskHostingDescriptionProvider
from parallels.plesk.source.plesk.hosting_description.provider.utils import entity_data_dump


class PleskHostingDescriptionProvider125(PleskHostingDescriptionProvider):
    """
    Use the method _entity_dump() and the decorator entity_data_dump() to catch unhandled exceptions
    """

    @entity_data_dump(messages.DATA_DUMP_MAIL_AUTO_REPLY_SETTINGS)
    def _get_mail_auto_reply(self, plesk_mail_name):
        """
        * The new field 'end_date' was added

        :type plesk_mail_name: parallels.plesk.source.plesk.hosting_description.plesk_entity.mail_name.MailName
        :rtype: dict | None
        """
        for plesk_mail_responder in self._plesk_entity.get_mail_responders(mail_name_id=plesk_mail_name.mail_name_id):
            if plesk_mail_responder.subject:
                forwarding = self._plesk_entity.get_selected_mail_responders_forwarding().get(plesk_mail_responder.mail_responder_id)
                return create_dict(
                    subject=plesk_mail_responder.subject,
                    message=plesk_mail_responder.text if plesk_mail_responder.text else '',
                    enabled=plesk_mail_name.auto_responder == 'true',
                    forwarding_address=forwarding[0] if forwarding else '',
                    content_type=plesk_mail_responder.content_type if plesk_mail_responder.content_type else None,
                    responses_frequency=plesk_mail_responder.ans_freq if plesk_mail_responder.ans_freq else None,
                    end_date=plesk_mail_responder.end_date if plesk_mail_responder.end_date else '',
                    attachments=self._plesk_entity.get_selected_mail_responders_attachments().get(plesk_mail_responder.mail_responder_id, []),
                )
        return None
