from collections import namedtuple

from .. import core

ApsPackageInfo = namedtuple('ApsPackageInfo', ('name', 'version', 'release',))


class ApsOperator(object):
    class GetPackagesList(core.operation_with_filter('GetPackagesList')):
        FilterAll = core.FilterAll

        operator_name = 'aps'
        operation_name = 'get-packages-list'
        min_api_version = '1.6.2.0'
        max_api_version = None

        @classmethod
        def parse(cls, elem):
            return core.parse_result_set(elem, cls._parse_data, 'package/name')

        @classmethod
        def _parse_data(cls, elem):
            return ApsPackageInfo(
                name=elem.findtext('package/name'), 
                version=elem.findtext('package/version'),
                release=elem.findtext('package/release')
            )