from collections import namedtuple

from parallels.core.utils.common import if_not_none
from parallels.core.utils.common.xml import elem, text_elem, seq

from .. import core


class ClientOperator(object):
    FilterAll = core.FilterAll
    FilterByLogin = core.declare_filter('FilterByLogin', 'login')

    ClientSetInfo = namedtuple('ClientSetInfo', ('gen_info',))
    ClientSetGenInfo = namedtuple('ClientSetGenInfo', ('passwd',))

    class Set(core.operation_with_filter('Get', ('values',))):
        operator_name = 'client'
        operation_name = 'set'
        min_api_version = '1.4.2.0'
        max_api_version = None

        def data_xml(self):
            return seq(
                elem('values', seq(
                    if_not_none(self.values.gen_info, lambda gi: elem('gen_info', [
                        if_not_none(gi.passwd, lambda p: text_elem('passwd', gi.passwd))
                    ]))
                ))
            )

        @classmethod
        def parse(cls, elem):
            return core.Result.parse(elem.find('result'))