# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package LegacyPanel::Toolbox;

use strict;
use warnings;

# following code was copied from PleskX/SpecificConfig.pm

sub _isDebian() {
  my ($self) = @_;
  return -e "/etc/debian_version";
}

sub _isSuse() {
  my ($self) = @_;
  return -e "/etc/SuSE-release";
}

sub getApacheUserInfo {
  my %apacheUser;
  if (_isDebian()) {
    $apacheUser{'user'}  = 'www-data';
    $apacheUser{'group'} = 'www-data';
  } elsif (_isSuse()) {
    $apacheUser{'user'}  = 'wwwrun';
    $apacheUser{'group'} = 'www';
  } else {
    $apacheUser{'user'}  = 'apache';
    $apacheUser{'group'} = 'apache';
  }
  return \%apacheUser;
}

# end of copied code

sub getApacheUid {
  my $apacheUser = getApacheUserInfo();
  my $uid = getpwnam($apacheUser->{'user'});
  if (wantarray()) {
    my $gid = getgrnam($apacheUser->{'group'});
    return ($uid, $gid);
  } else {
    return $uid;
  }
}

1;

