# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package ExtensionPackageMessage;

use strict;
eval{require warnings;1;};

sub new {
  my $self = {};
  bless( $self, shift );
  $self->{details} = undef;
  $self->{resolution} = undef;
  $self->{innermessages} = [];
  $self->_init(@_);
  return $self;
}

sub _init {
  my ( $self, $messageDescription ) = @_;
  
  $self->{text} = $messageDescription->{'text'};
  $self->{resolution} = $messageDescription->{'resolution'};
  $self->{details} = $messageDescription->{'details'};
  $self->{severity} = $messageDescription->{'severity'};
  $self->{code} = $messageDescription->{'code'};
  
  if (defined($messageDescription->{'message'})) {
    foreach my $innerMessage (@{$messageDescription->{'message'}}) {
      push @{$self->{innermessages}}, ExtensionPackageMessage->new($innerMessage);
    }
  }
}

sub getText {
  my $self = shift;
  return $self->{text}[0];
}

sub getResolution {
  my $self = shift;
  return $self->{resolution}[0];
}

sub getDetails {
  my $self = shift;
  return $self->{details}[0];
}

sub getSeverity {
  my $self = shift;
  return $self->{severity}[0];
}

sub getCode {
  my $self = shift;
  return $self->{code}[0];
}

sub getInnerMessages {
  my $self = shift;
  return $self->{innermessages};
}