#!/usr/bin/eperl
# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
#
# List full paths to www-root and cgi-root directories 
# for all subdomains of domain specified as a first argument
# Format of output - for each subdomain the following line is printed:
# subdomain_short_name\twww_root\tcgi_root

# Modules search order is:
# 1) Modules from shared_legacy in the current directory
# 2) Modules from the current directory
# 3) Modules from shared
use lib '.';
use lib 'shared_legacy';

use DomainDumper;

$listOfSubdomains = DomainDumper::getListOfSubdomains($ARGV[0]);
while (my ($subdomainName, $subdomainInfo) = each %{$listOfSubdomains}) {
        print $subdomainName . "\t";
        print $subdomainInfo->{'document_root'} . "\t";
        print $subdomainInfo->{'cgi_root'} . "\n";
}
