from parallels.ppa import messages
from parallels.core.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.core.actions.utils.logging_properties \
	import LoggingProperties
from parallels.core.checking import Problem
from parallels.core.utils.common.ip import is_ipv4
from parallels.core.utils.common.ip import is_ipv6


class CatchAllRedirect(SubscriptionBackupAction):
	def get_description(self):
		return messages.CHECK_CATCHALL_REDIRECTS_ANOTHER_SERVER

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return messages.FAILED_CHECK_CATCH_ALL_REDIRECTS_FOR % subscription.name

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed for a subscription, migration tool
		won't run the next operations for the subscription.

		:rtype: bool
		"""
		return False

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		if subscription_backup.mailsystem is not None: # catch-all is a subscription wide option,
			#  no need to check addon domains and subdomains
			catch_all_value = subscription_backup.mailsystem.get_catch_all()
			if catch_all_value is not None and (is_ipv4(catch_all_value) or is_ipv6(catch_all_value)):
				subscription.add_report_issue(
					global_context.pre_check_report,
					Problem(
						'catch_all_redirect_to_external_server', Problem.WARNING, 
						messages.SOURCE_SERVER_ALL_MAIL_THAT_WAS % (
							catch_all_value,
						)
					),
					messages.ALL_MAIL_THAT_IS_SENT_NONEXISTENT)
