from parallels.ppa.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertPPADNS
from parallels.plesk.utils.xml_rpc.plesk.operator.dns import DnsRecord


class DNS(ActionHostingSettingsConvertPPADNS):
	def _get_source_dns_template(self, global_context, subscription):
		"""Make server dns template like dns server template in Plesk.
		Backup argument is not used for helm migrator. it's used in Plesks migrators.
		"""
		server_dns_template = [
			DnsRecord(id=None, rec_type='A', src='<domain>', dst='<ip>', opt=''),
			DnsRecord(id=None, rec_type='A', src='*.<domain>', dst='<ip>', opt=''),
			DnsRecord(id=None, rec_type='TXT', src='<domain>', dst='v=spf1 a mx -all', opt='')
		]

		return server_dns_template
