from parallels.pvps import messages
import logging
from parallels.core.actions.base.subscription_action import SubscriptionAction


logger = logging.getLogger(__name__)


class CheckPVPSConnections(SubscriptionAction):
	def get_description(self):
		return messages.CHECK_CONNECTIONS_TO_PVPS

	def get_failure_message(self, global_context, subscription):
		"""
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.ERROR_WHILE_CHECKING_CONNECTION_TO_PVPS

	def filter_subscription(self, global_context, subscription):
		"""
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return True

	def run(self, global_context, subscription):
		"""
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		logger.debug(messages.CHECK_CONNECTIONS_TO_TARGET_NODES)
		subscription.panel_target_server.check_connections()
