from contextlib import contextmanager
from parallels.core.run_command import LocalUnixRunner
from parallels.ppa.run_command.unix_hcl_runner import UnixHclRunner
from parallels.plesk.utils.xml_rpc.plesk.operator import IpAddressInfo
from parallels.ppa.connections.target_server import PPATargetServer
from parallels.core.utils.common import cached
from parallels.shcm_web_sn import messages


class SHCMMoveWebspacesTargetServer(PPATargetServer):
	def __init__(self, conn, ppa_host_id, ip, vhosts_dir=None):
		super(SHCMMoveWebspacesTargetServer, self).__init__(conn, ppa_host_id, ip)
		self._vhosts_dir = vhosts_dir

	@cached
	def description(self):
		return messages.TARGET_PPA_WEB_SN

	@contextmanager
	def runner(self):
		yield UnixHclRunner(LocalUnixRunner(), self.ppa_host_id,
			self.conn.get_ppa_node_description(self.ppa_host_id))

	@property
	def plesk_version(self):
		return 12, 1

	@cached
	def get_all_ips(self, global_context):
		ips = []
		if global_context.webspace_ipv4 is not None:
			ips.append(IpAddressInfo(
				ip_address=global_context.webspace_ipv4,
				ip_type=global_context.webspace_ipv4_type,
				public_ip_address=global_context.webspace_ipv4
			))

		if global_context.webspace_ipv6 is not None:
			ips.append(IpAddressInfo(
				ip_address=global_context.webspace_ipv6,
				ip_type=global_context.webspace_ipv6_type,
				public_ip_address=global_context.webspace_ipv6
			))

		return ips

	@property
	@cached
	def vhosts_dir(self):
		return self._vhosts_dir if self._vhosts_dir else super(SHCMMoveWebspacesTargetServer, self).vhosts_dir()
